/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.kotlin;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.beam.examples.kotlin.WordCount;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/beam/examples/kotlin/DebuggingWordCount;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "runDebuggingWordCount", "options", "Lorg/apache/beam/examples/kotlin/DebuggingWordCount$WordCountOptions;", "FilterTextFn", "WordCountOptions", "beam-examples-kotlin"})
public final class DebuggingWordCount {
    public static final DebuggingWordCount INSTANCE;

    @JvmStatic
    public static final void runDebuggingWordCount(@NotNull WordCountOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection filteredWords = (PCollection)((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)new WordCount.CountWords())).apply((PTransform)ParDo.of((DoFn)new FilterTextFn(options.getFilterPattern())));
        List expectedResults = CollectionsKt.listOf((Object[])new KV[]{KV.of((Object)"Flourish", (Object)3L), KV.of((Object)"stomach", (Object)1L)});
        PAssert.that((PCollection)filteredWords).containsInAnyOrder((Iterable)expectedResults);
        p.run().waitUntilFinish();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        PipelineOptionsFactory.Builder builder = PipelineOptionsFactory.fromArgs((String[])Arrays.copyOf(args, args.length)).withValidation();
        if (builder == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.beam.examples.kotlin.DebuggingWordCount.WordCountOptions");
        }
        WordCountOptions options = (WordCountOptions)builder;
        DebuggingWordCount.runDebuggingWordCount(options);
    }

    private DebuggingWordCount() {
    }

    static {
        DebuggingWordCount debuggingWordCount;
        INSTANCE = debuggingWordCount = new DebuggingWordCount();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J8\u0010\r\u001a\u00020\u000e2.\u0010\u000f\u001a*0\u0010R&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/apache/beam/examples/kotlin/DebuggingWordCount$FilterTextFn;", "Lorg/apache/beam/sdk/transforms/DoFn;", "Lorg/apache/beam/sdk/values/KV;", "", "", "pattern", "(Ljava/lang/String;)V", "filter", "Ljava/util/regex/Pattern;", "matchedWords", "Lorg/apache/beam/sdk/metrics/Counter;", "kotlin.jvm.PlatformType", "unmatchedWords", "processElement", "", "c", "Lorg/apache/beam/sdk/transforms/DoFn$ProcessContext;", "Companion", "beam-examples-kotlin"})
    public static final class FilterTextFn
    extends DoFn<KV<String, Long>, KV<String, Long>> {
        private final Pattern filter;
        private final Counter matchedWords;
        private final Counter unmatchedWords;
        private static final Logger LOG;
        public static final Companion Companion;

        @DoFn.ProcessElement
        public final void processElement(@NotNull DoFn.ProcessContext c) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Object object = c.element();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"c.element()");
            if (this.filter.matcher((CharSequence)((KV)object).getKey()).matches()) {
                StringBuilder stringBuilder = new StringBuilder().append("Matched: ");
                Object object2 = c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"c.element()");
                LOG.debug(stringBuilder.append((String)((KV)object2).getKey()).toString());
                this.matchedWords.inc();
                c.output(c.element());
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Did not match: ");
                Object object3 = c.element();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"c.element()");
                LOG.trace(stringBuilder.append((String)((KV)object3).getKey()).toString());
                this.unmatchedWords.inc();
            }
        }

        public FilterTextFn(@NotNull String pattern) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Pattern pattern2 = Pattern.compile(pattern);
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"Pattern.compile(pattern)");
            this.filter = pattern2;
            this.matchedWords = Metrics.counter(FilterTextFn.class, (String)"matchedWords");
            this.unmatchedWords = Metrics.counter(FilterTextFn.class, (String)"unmatchedWords");
        }

        static {
            Companion = new Companion(null);
            LOG = LoggerFactory.getLogger(FilterTextFn.class);
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/beam/examples/kotlin/DebuggingWordCount$FilterTextFn$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "beam-examples-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u00020\u00038gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/beam/examples/kotlin/DebuggingWordCount$WordCountOptions;", "Lorg/apache/beam/examples/kotlin/WordCount$WordCountOptions;", "filterPattern", "", "getFilterPattern", "()Ljava/lang/String;", "setFilterPattern", "(Ljava/lang/String;)V", "beam-examples-kotlin"})
    public static interface WordCountOptions
    extends WordCount.WordCountOptions {
        @Description(value="Regex filter pattern to use in DebuggingWordCount. Only words matching this pattern will be counted.")
        @Default.String(value="Flourish|stomach")
        @NotNull
        public String getFilterPattern();

        public void setFilterPattern(@NotNull String var1);
    }
}

