/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Date;
import org.apache.beam.examples.kotlin.WordCount;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WordCountITKotlin {
    private static final String DEFAULT_INPUT = "gs://apache-beam-samples/shakespeare/winterstale-personae";
    private static final String DEFAULT_OUTPUT_CHECKSUM = "ebf895e7324e8a3edc72e7bcc96fa2ba7f690def";

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TestPipelineOptions.class);
    }

    @Test
    public void testE2EWordCount() throws Exception {
        WordCountITOptions options = (WordCountITOptions)TestPipeline.testingPipelineOptions().as(WordCountITOptions.class);
        options.setInputFile(DEFAULT_INPUT);
        options.setOutput(FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true).resolve(String.format("WordCountITKotlin-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        options.setOnSuccessMatcher((SerializableMatcher)new FileChecksumMatcher(DEFAULT_OUTPUT_CHECKSUM, options.getOutput() + "*-of-*"));
        WordCount.runWordCount((WordCount.WordCountOptions)options);
    }

    public static interface WordCountITOptions
    extends TestPipelineOptions,
    WordCount.WordCountOptions {
    }
}

