/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.apache.beam.examples.WindowedWordCountITKotlin;
import org.apache.beam.examples.kotlin.WindowedWordCount;
import org.apache.beam.examples.kotlin.common.WriteOneFilePerWindow;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.StreamingIT;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.ExplicitShardedFile;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/apache/beam/examples/WindowedWordCountITKotlin;", "", "()V", "testName", "Lorg/junit/rules/TestName;", "getTestName", "()Lorg/junit/rules/TestName;", "setTestName", "(Lorg/junit/rules/TestName;)V", "batchOptions", "Lorg/apache/beam/examples/WindowedWordCountITKotlin$WindowedWordCountITOptions;", "defaultOptions", "streamingOptions", "testWindowedWordCountInBatchDynamicSharding", "", "testWindowedWordCountInBatchStaticSharding", "testWindowedWordCountInStreamingStaticSharding", "testWindowedWordCountPipeline", "options", "Companion", "WindowedWordCountITOptions", "WordCountsMatcher", "beam-examples-kotlin"})
public final class WindowedWordCountITKotlin {
    @Rule
    @NotNull
    private TestName testName = new TestName();
    private static final String DEFAULT_INPUT = "gs://apache-beam-samples/shakespeare/sonnets.txt";
    private static final int MAX_READ_RETRIES = 4;
    private static final Duration DEFAULT_SLEEP_DURATION;
    private static final FluentBackoff BACK_OFF_FACTORY;
    public static final Companion Companion;

    @NotNull
    public final TestName getTestName() {
        return this.testName;
    }

    public final void setTestName(@NotNull TestName testName) {
        Intrinsics.checkParameterIsNotNull((Object)testName, (String)"<set-?>");
        this.testName = testName;
    }

    @Test
    public final void testWindowedWordCountInBatchDynamicSharding() throws Exception {
        WindowedWordCountITOptions options = this.batchOptions();
        options.setNumShards(null);
        this.testWindowedWordCountPipeline(options);
    }

    @Test
    public final void testWindowedWordCountInBatchStaticSharding() throws Exception {
        WindowedWordCountITOptions options = this.batchOptions();
        options.setNumShards(3);
        this.testWindowedWordCountPipeline(options);
    }

    @Test
    @Category(value={StreamingIT.class})
    public final void testWindowedWordCountInStreamingStaticSharding() throws Exception {
        WindowedWordCountITOptions options = this.streamingOptions();
        options.setNumShards(3);
        this.testWindowedWordCountPipeline(options);
    }

    private final WindowedWordCountITOptions defaultOptions() throws Exception {
        WindowedWordCountITOptions options = (WindowedWordCountITOptions)TestPipeline.testingPipelineOptions().as(WindowedWordCountITOptions.class);
        options.setInputFile(DEFAULT_INPUT);
        WindowedWordCountITOptions windowedWordCountITOptions = options;
        Intrinsics.checkExpressionValueIsNotNull((Object)windowedWordCountITOptions, (String)"options");
        windowedWordCountITOptions.setTestTimeoutSeconds(1200L);
        options.setMinTimestampMillis(0L);
        Duration duration = Duration.standardHours((long)1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardHours(1)");
        options.setMinTimestampMillis(duration.getMillis());
        options.setWindowSize(10);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "WindowedWordCountITKotlin.%s-%tFT%<tH:%<tM:%<tS.%<tL+%s";
        Object[] objectArray = new Object[]{this.testName.getMethodName(), new Date(), ThreadLocalRandom.current().nextInt()};
        ResourceId resourceId = FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true);
        WindowedWordCountITOptions windowedWordCountITOptions2 = options;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        windowedWordCountITOptions2.setOutput(resourceId.resolve(string3, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        return options;
    }

    private final WindowedWordCountITOptions streamingOptions() throws Exception {
        WindowedWordCountITOptions options = this.defaultOptions();
        options.setStreaming(true);
        return options;
    }

    private final WindowedWordCountITOptions batchOptions() throws Exception {
        WindowedWordCountITOptions options = this.defaultOptions();
        options.setStreaming(false);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private final void testWindowedWordCountPipeline(WindowedWordCountITOptions options) throws Exception {
        ResourceId output;
        ResourceId resourceId = output = FileBasedSink.convertToFileResourceIfPossible((String)options.getOutput());
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceId, (String)"output");
        WriteOneFilePerWindow.PerWindowFiles filenamePolicy = new WriteOneFilePerWindow.PerWindowFiles(resourceId);
        ArrayList expectedOutputFiles = Lists.newArrayListWithCapacity((int)6);
        for (Integer startMinute : ImmutableList.of((Object)0, (Object)10, (Object)20, (Object)30, (Object)40, (Object)50)) {
            Instant windowStart = new Instant((Object)options.getMinTimestampMillis()).plus((ReadableDuration)Duration.standardMinutes((long)startMinute.intValue()));
            String filePrefix = filenamePolicy.filenamePrefixForWindow(new IntervalWindow(windowStart, windowStart.plus((ReadableDuration)Duration.standardMinutes((long)10L))));
            expectedOutputFiles.add(new NumberedShardedFile(output.getCurrentDirectory().resolve(filePrefix, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString() + "*"));
        }
        ExplicitShardedFile inputFile = new ExplicitShardedFile((Collection)SetsKt.setOf((Object)options.getInputFile()));
        TreeMap expectedWordCounts = new TreeMap();
        Iterator iterator = inputFile.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff()).iterator();
        while (iterator.hasNext()) {
            String[] words;
            void thisCollection$iv;
            void $receiver$iv;
            String line;
            String string = line = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
            Object object = string;
            String string2 = "[^\\p{L}]+";
            string2 = new Regex(string2);
            int n = 0;
            object = string2.split((CharSequence)object, n);
            if ($receiver$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String word : words) {
                Object object2 = word;
                if (!(object2.length() > 0)) continue;
                object2 = expectedWordCounts;
                Long l = ((Number)MoreObjects.firstNonNull(expectedWordCounts.get(word), (Object)0L)).longValue() + 1L;
                object2.put(word, l);
            }
        }
        SortedMap sortedMap = expectedWordCounts;
        ArrayList arrayList = expectedOutputFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"expectedOutputFiles");
        options.setOnSuccessMatcher(new WordCountsMatcher(sortedMap, arrayList));
        WindowedWordCount.runWindowedWordCount((WindowedWordCount.Options)options);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_SLEEP_DURATION = Duration.standardSeconds((long)10L);
        BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003\u00a8\u0006\u0004"}, d2={"Lorg/apache/beam/examples/WindowedWordCountITKotlin$WindowedWordCountITOptions;", "Lorg/apache/beam/examples/kotlin/WindowedWordCount$Options;", "Lorg/apache/beam/sdk/testing/TestPipelineOptions;", "Lorg/apache/beam/sdk/options/StreamingOptions;", "beam-examples-kotlin"})
    public static interface WindowedWordCountITOptions
    extends WindowedWordCount.Options,
    TestPipelineOptions,
    StreamingOptions {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B'\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/apache/beam/examples/WindowedWordCountITKotlin$WordCountsMatcher;", "Lorg/hamcrest/TypeSafeMatcher;", "Lorg/apache/beam/sdk/PipelineResult;", "Lorg/apache/beam/sdk/testing/SerializableMatcher;", "expectedWordCounts", "Ljava/util/SortedMap;", "", "", "outputFiles", "", "Lorg/apache/beam/sdk/util/ShardedFile;", "(Ljava/util/SortedMap;Ljava/util/List;)V", "actualCounts", "describeMismatchSafely", "", "pResult", "description", "Lorg/hamcrest/Description;", "describeTo", "matchesSafely", "", "pipelineResult", "beam-examples-kotlin"})
    private static final class WordCountsMatcher
    extends TypeSafeMatcher<PipelineResult>
    implements SerializableMatcher<PipelineResult> {
        private SortedMap<String, Long> actualCounts;
        private final SortedMap<String, Long> expectedWordCounts;
        private final List<ShardedFile> outputFiles;

        /*
         * WARNING - void declaration
         */
        public boolean matchesSafely(@NotNull PipelineResult pipelineResult) {
            Intrinsics.checkParameterIsNotNull((Object)pipelineResult, (String)"pipelineResult");
            try {
                ArrayList outputLines = new ArrayList();
                for (ShardedFile outputFile : this.outputFiles) {
                    outputLines.addAll(outputFile.readFilesWithRetries(Sleeper.DEFAULT, Companion.getBACK_OFF_FACTORY$beam_examples_kotlin().backoff()));
                }
                this.actualCounts = new TreeMap();
                Iterator<Object> iterator = outputLines.iterator();
                while (iterator.hasNext()) {
                    String[] splits;
                    void thisCollection$iv;
                    void $receiver$iv;
                    String line;
                    String string = line = (String)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                    Object object = string;
                    String string2 = ": ";
                    string2 = new Regex(string2);
                    int n = 0;
                    object = string2.split((CharSequence)object, n);
                    if ($receiver$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String word = splits[0];
                    long count = Long.parseLong(splits[1]);
                    SortedMap<String, Long> sortedMap = this.actualCounts;
                    if (sortedMap == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Map<kotlin.String, kotlin.Long>");
                    }
                    ((Map)sortedMap).merge(word, count, matchesSafely.1.INSTANCE);
                }
                return Intrinsics.areEqual(this.actualCounts, this.expectedWordCounts);
            }
            catch (Exception e) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Failed to read from sharded output: %s due to exception";
                Object[] objectArray = new Object[]{this.outputFiles};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                Throwable throwable = e;
                String string5 = string4;
                throw (Throwable)new RuntimeException(string5, throwable);
            }
        }

        public void describeTo(@NotNull Description description) {
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            Matchers.equalTo(this.expectedWordCounts).describeTo(description);
        }

        public void describeMismatchSafely(@NotNull PipelineResult pResult, @NotNull Description description) {
            Intrinsics.checkParameterIsNotNull((Object)pResult, (String)"pResult");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            Matchers.equalTo(this.expectedWordCounts).describeMismatch(this.actualCounts, description);
        }

        public WordCountsMatcher(@NotNull SortedMap<String, Long> expectedWordCounts, @NotNull List<? extends ShardedFile> outputFiles) {
            Intrinsics.checkParameterIsNotNull(expectedWordCounts, (String)"expectedWordCounts");
            Intrinsics.checkParameterIsNotNull(outputFiles, (String)"outputFiles");
            this.expectedWordCounts = expectedWordCounts;
            this.outputFiles = outputFiles;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/apache/beam/examples/WindowedWordCountITKotlin$Companion;", "", "()V", "BACK_OFF_FACTORY", "Lorg/apache/beam/sdk/util/FluentBackoff;", "kotlin.jvm.PlatformType", "getBACK_OFF_FACTORY$beam_examples_kotlin", "()Lorg/apache/beam/sdk/util/FluentBackoff;", "DEFAULT_INPUT", "", "DEFAULT_SLEEP_DURATION", "Lorg/joda/time/Duration;", "MAX_READ_RETRIES", "", "setUp", "", "beam-examples-kotlin"})
    public static final class Companion {
        public final FluentBackoff getBACK_OFF_FACTORY$beam_examples_kotlin() {
            return BACK_OFF_FACTORY;
        }

        @BeforeClass
        public final void setUp() {
            PipelineOptionsFactory.register(TestPipelineOptions.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

