/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MinimalWordCountTestKotlin
implements Serializable {
    @Rule
    public TestPipeline p = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Test
    public void testMinimalWordCount() throws Exception {
        ((GcsOptions)this.p.getOptions().as(GcsOptions.class)).setGcsUtil(this.buildMockGcsUtil());
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.p.apply((PTransform)TextIO.read().from("gs://apache-beam-samples/shakespeare/*"))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)word -> Arrays.asList(word.split("[^a-zA-Z']+"))))).apply((PTransform)Filter.by((SerializableFunction & Serializable)word -> !word.isEmpty()))).apply(Count.perElement())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)wordCount -> (String)wordCount.getKey() + ": " + wordCount.getValue()))).apply((PTransform)TextIO.write().to("gs://your-output-bucket/and-output-prefix"));
    }

    private GcsUtil buildMockGcsUtil() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.open((GcsPath)Mockito.any(GcsPath.class))).then(invocation -> FileChannel.open(Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE));
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Mockito.any(GcsPath.class))).then(invocation -> ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0])));
        return mockGcsUtil;
    }
}

