/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.examples.complete.game.utils.WriteToBigQuery;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class WriteWindowedToBigQuery<T>
extends WriteToBigQuery<T> {
    public WriteWindowedToBigQuery(String tableName, Map<String, WriteToBigQuery.FieldInfo<T>> fieldInfo) {
        super(tableName, fieldInfo);
    }

    @Override
    public PDone apply(PCollection<T> teamAndScore) {
        return (PDone)((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)BigQueryIO.Write.to((TableReference)WriteWindowedToBigQuery.getTable(teamAndScore.getPipeline(), this.tableName)).withSchema(this.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
    }

    protected class BuildRowFn
    extends DoFn<T, TableRow>
    implements DoFn.RequiresWindowAccess {
        protected BuildRowFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            TableRow row = new TableRow();
            for (Map.Entry entry : WriteWindowedToBigQuery.this.fieldInfo.entrySet()) {
                String key = (String)entry.getKey();
                WriteToBigQuery.FieldInfo fcnInfo = (WriteToBigQuery.FieldInfo)entry.getValue();
                SerializableFunction<DoFn.ProcessContext, Object> fcn = fcnInfo.getFieldFn();
                row.set(key, fcn.apply((Object)c));
            }
            c.output((Object)row);
        }
    }
}

