/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.examples.complete.game.UserScore;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.GcpOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class WriteToBigQuery<T>
extends PTransform<PCollection<T>, PDone> {
    protected String tableName;
    protected Map<String, FieldInfo<T>> fieldInfo;

    public WriteToBigQuery() {
    }

    public WriteToBigQuery(String tableName, Map<String, FieldInfo<T>> fieldInfo) {
        this.tableName = tableName;
        this.fieldInfo = fieldInfo;
    }

    protected TableSchema getSchema() {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        for (Map.Entry<String, FieldInfo<T>> entry : this.fieldInfo.entrySet()) {
            String key = entry.getKey();
            FieldInfo<T> fcnInfo = entry.getValue();
            String bqType = fcnInfo.getFieldType();
            fields.add(new TableFieldSchema().setName(key).setType(bqType));
        }
        return new TableSchema().setFields(fields);
    }

    public PDone apply(PCollection<T> teamAndScore) {
        return (PDone)((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)BigQueryIO.Write.to((TableReference)WriteToBigQuery.getTable(teamAndScore.getPipeline(), this.tableName)).withSchema(this.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
    }

    static TableReference getTable(Pipeline pipeline, String tableName) {
        PipelineOptions options = pipeline.getOptions();
        TableReference table = new TableReference();
        table.setDatasetId(((UserScore.Options)options.as(UserScore.Options.class)).getDataset());
        table.setProjectId(((GcpOptions)options.as(GcpOptions.class)).getProject());
        table.setTableId(tableName);
        return table;
    }

    protected class BuildRowFn
    extends DoFn<T, TableRow> {
        protected BuildRowFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            TableRow row = new TableRow();
            for (Map.Entry entry : WriteToBigQuery.this.fieldInfo.entrySet()) {
                String key = entry.getKey();
                FieldInfo fcnInfo = entry.getValue();
                SerializableFunction<DoFn.ProcessContext, Object> fcn = fcnInfo.getFieldFn();
                row.set(key, fcn.apply((Object)c));
            }
            c.output((Object)row);
        }
    }

    public static class FieldInfo<T>
    implements Serializable {
        private String fieldType;
        private SerializableFunction<DoFn.ProcessContext, Object> fieldFn;

        public FieldInfo(String fieldType, SerializableFunction<DoFn.ProcessContext, Object> fieldFn) {
            this.fieldType = fieldType;
            this.fieldFn = fieldFn;
        }

        String getFieldType() {
            return this.fieldType;
        }

        SerializableFunction<DoFn.ProcessContext, Object> getFieldFn() {
            return this.fieldFn;
        }
    }
}

