/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.beam.examples.complete.game.UserScore;
import org.apache.beam.examples.complete.game.utils.WriteToBigQuery;
import org.apache.beam.examples.complete.game.utils.WriteWindowedToBigQuery;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HourlyTeamScore
extends UserScore {
    private static DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST")));
    private static DateTimeFormatter minFmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd-HH-mm").withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST")));

    protected static Map<String, WriteToBigQuery.FieldInfo<KV<String, Integer>>> configureWindowedTableWrite() {
        HashMap<String, WriteToBigQuery.FieldInfo<KV<String, Integer>>> tableConfig = new HashMap<String, WriteToBigQuery.FieldInfo<KV<String, Integer>>>();
        tableConfig.put("team", new WriteToBigQuery.FieldInfo("STRING", (SerializableFunction<DoFn.ProcessContext, Object>)(SerializableFunction & Serializable)c -> (String)((KV)c.element()).getKey()));
        tableConfig.put("total_score", new WriteToBigQuery.FieldInfo("INTEGER", (SerializableFunction<DoFn.ProcessContext, Object>)(SerializableFunction & Serializable)c -> (Integer)((KV)c.element()).getValue()));
        tableConfig.put("window_start", new WriteToBigQuery.FieldInfo("STRING", (SerializableFunction<DoFn.ProcessContext, Object>)(SerializableFunction & Serializable)c -> {
            IntervalWindow w = (IntervalWindow)c.window();
            return fmt.print((ReadableInstant)w.start());
        }));
        return tableConfig;
    }

    public static void main(String[] args) throws Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        Instant stopMinTimestamp = new Instant(minFmt.parseMillis(options.getStopMin()));
        Instant startMinTimestamp = new Instant(minFmt.parseMillis(options.getStartMin()));
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply((PTransform)TextIO.Read.from((String)options.getInput()))).apply("ParseGameEvent", (PTransform)ParDo.of((DoFn)new UserScore.ParseEventFn()))).apply("FilterStartTime", (PTransform)Filter.by((SerializableFunction & Serializable)gInfo -> gInfo.getTimestamp() > startMinTimestamp.getMillis()))).apply("FilterEndTime", (PTransform)Filter.by((SerializableFunction & Serializable)gInfo -> gInfo.getTimestamp() < stopMinTimestamp.getMillis()))).apply("AddEventTimestamps", (PTransform)WithTimestamps.of((SerializableFunction & Serializable)i -> new Instant((Object)i.getTimestamp())))).apply("FixedWindowsTeam", (PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)options.getWindowDuration().intValue()))))).apply("ExtractTeamScore", (PTransform)new UserScore.ExtractAndSumScore("team"))).apply("WriteTeamScoreSums", new WriteWindowedToBigQuery(options.getTableName(), HourlyTeamScore.configureWindowedTableWrite()));
        pipeline.run();
    }

    static interface Options
    extends UserScore.Options {
        @Description(value="Numeric value of fixed window duration, in minutes")
        @Default.Integer(value=60)
        public Integer getWindowDuration();

        public void setWindowDuration(Integer var1);

        @Description(value="String representation of the first minute after which to generate results,in the format: yyyy-MM-dd-HH-mm . This time should be in PST.Any input data timestamped prior to that minute won't be included in the sums.")
        @Default.String(value="1970-01-01-00-00")
        public String getStartMin();

        public void setStartMin(String var1);

        @Description(value="String representation of the first minute for which to not generate results,in the format: yyyy-MM-dd-HH-mm . This time should be in PST.Any input data timestamped after that minute won't be included in the sums.")
        @Default.String(value="2100-01-01-00-00")
        public String getStopMin();

        public void setStopMin(String var1);

        @Override
        @Description(value="The BigQuery table name. Should not already exist.")
        @Default.String(value="hourly_team_score")
        public String getTableName();

        @Override
        public void setTableName(String var1);
    }
}

