/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.GcsOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class MinimalWordCountJava8Test
implements Serializable {
    @Test
    public void testMinimalWordCountJava8() throws Exception {
        TestPipeline p = TestPipeline.create();
        ((GcsOptions)p.getOptions().as(GcsOptions.class)).setGcsUtil(this.buildMockGcsUtil());
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.from((String)"gs://dataflow-samples/shakespeare/*"))).apply((PTransform)FlatMapElements.via((SerializableFunction & Serializable)word -> Arrays.asList(word.split("[^a-zA-Z']+"))).withOutputType(TypeDescriptors.strings()))).apply((PTransform)Filter.by((SerializableFunction & Serializable)word -> !word.isEmpty()))).apply((PTransform)Count.perElement())).apply((PTransform)MapElements.via((SerializableFunction & Serializable)wordCount -> (String)wordCount.getKey() + ": " + wordCount.getValue()).withOutputType(TypeDescriptors.strings()))).apply((PTransform)TextIO.Write.to((String)"gs://YOUR_OUTPUT_BUCKET/AND_OUTPUT_PREFIX"));
    }

    private GcsUtil buildMockGcsUtil() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.open((GcsPath)Mockito.any(GcsPath.class))).then((Answer)new Answer<SeekableByteChannel>(){

            public SeekableByteChannel answer(InvocationOnMock invocation) throws Throwable {
                return FileChannel.open(Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
            }
        });
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Mockito.any(GcsPath.class))).then((Answer)new Answer<List<GcsPath>>(){

            public List<GcsPath> answer(InvocationOnMock invocation) throws Throwable {
                return ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0]));
            }
        });
        return mockGcsUtil;
    }
}

