/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.runners.dataflow.BlockingDataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;

public class MinimalWordCountJava8 {
    public static void main(String[] args) {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setRunner(BlockingDataflowPipelineRunner.class);
        options.setProject("SET_YOUR_PROJECT_ID_HERE");
        options.setStagingLocation("gs://SET_YOUR_BUCKET_NAME_HERE/AND_STAGING_DIRECTORY");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.from((String)"gs://dataflow-samples/shakespeare/*"))).apply((PTransform)FlatMapElements.via((SerializableFunction & Serializable)word -> Arrays.asList(word.split("[^a-zA-Z']+"))).withOutputType((TypeDescriptor)new TypeDescriptor<String>(){}))).apply((PTransform)Filter.byPredicate((SerializableFunction & Serializable)word -> !word.isEmpty()))).apply((PTransform)Count.perElement())).apply((PTransform)MapElements.via((SerializableFunction & Serializable)wordCount -> {
            String string = (String)wordCount.getKey();
            String string2 = String.valueOf(wordCount.getValue());
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
        }).withOutputType((TypeDescriptor)new TypeDescriptor<String>(){}))).apply((PTransform)TextIO.Write.to((String)"gs://YOUR_OUTPUT_BUCKET/AND_OUTPUT_PREFIX"));
        p.run();
    }
}

