/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.complete.game.UserScore;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HourlyTeamScoreTest
implements Serializable {
    static final String[] GAME_EVENTS_ARRAY = new String[]{"user0_MagentaKangaroo,MagentaKangaroo,3,1447955630000,2015-11-19 09:53:53.444", "user13_ApricotQuokka,ApricotQuokka,15,1447955630000,2015-11-19 09:53:53.444", "user6_AmberNumbat,AmberNumbat,11,1447955630000,2015-11-19 09:53:53.444", "user7_AlmondWallaby,AlmondWallaby,15,1447955630000,2015-11-19 09:53:53.444", "user7_AndroidGreenKookaburra,AndroidGreenKookaburra,12,1447955630000,2015-11-19 09:53:53.444", "user7_AndroidGreenKookaburra,AndroidGreenKookaburra,11,1447955630000,2015-11-19 09:53:53.444", "user19_BisqueBilby,BisqueBilby,6,1447955630000,2015-11-19 09:53:53.444", "user19_BisqueBilby,BisqueBilby,8,1447955630000,2015-11-19 09:53:53.444", "user0_AndroidGreenEchidna,AndroidGreenEchidna,0,1447965690000,2015-11-19 12:41:31.053", "user0_MagentaKangaroo,MagentaKangaroo,4,1447965690000,2015-11-19 12:41:31.053", "user2_AmberCockatoo,AmberCockatoo,13,1447965690000,2015-11-19 12:41:31.053", "user18_BananaEmu,BananaEmu,7,1447965690000,2015-11-19 12:41:31.053", "user3_BananaEmu,BananaEmu,17,1447965690000,2015-11-19 12:41:31.053", "user18_BananaEmu,BananaEmu,1,1447965690000,2015-11-19 12:41:31.053", "user18_ApricotCaneToad,ApricotCaneToad,14,1447965690000,2015-11-19 12:41:31.053"};
    static final List<String> GAME_EVENTS = Arrays.asList(GAME_EVENTS_ARRAY);
    static final KV[] FILTERED_EVENTS = new KV[]{KV.of((Object)"user0_AndroidGreenEchidna", (Object)0), KV.of((Object)"user0_MagentaKangaroo", (Object)4), KV.of((Object)"user2_AmberCockatoo", (Object)13), KV.of((Object)"user18_BananaEmu", (Object)7), KV.of((Object)"user3_BananaEmu", (Object)17), KV.of((Object)"user18_BananaEmu", (Object)1), KV.of((Object)"user18_ApricotCaneToad", (Object)14)};

    @Test
    @Category(value={RunnableOnService.class})
    public void testUserScoresFilter() throws Exception {
        TestPipeline p = TestPipeline.create();
        Instant startMinTimestamp = new Instant(1447965680000L);
        PCollection input = (PCollection)p.apply((PTransform)Create.of(GAME_EVENTS).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.named((String)"ParseGameEvent").of((DoFn)new UserScore.ParseEventFn()))).apply("FilterStartTime", (PTransform)Filter.byPredicate((SerializableFunction & Serializable)gInfo -> gInfo.getTimestamp() > startMinTimestamp.getMillis()))).apply((PTransform)MapElements.via((SerializableFunction & Serializable)gInfo -> KV.of((Object)gInfo.getUser(), (Object)gInfo.getScore())).withOutputType((TypeDescriptor)new TypeDescriptor<KV<String, Integer>>(){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])FILTERED_EVENTS);
        p.run();
    }
}

