/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.beam.examples.WordCount;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExampleUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class WindowedWordCount {
    static final int WINDOW_SIZE = 1;

    private static TableSchema getSchema() {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("word").setType("STRING"));
        fields.add(new TableFieldSchema().setName("count").setType("INTEGER"));
        fields.add(new TableFieldSchema().setName("window_timestamp").setType("TIMESTAMP"));
        TableSchema schema = new TableSchema().setFields(fields);
        return schema;
    }

    private static TableReference getTableReference(Options options) {
        TableReference tableRef = new TableReference();
        tableRef.setProjectId(options.getProject());
        tableRef.setDatasetId(options.getBigQueryDataset());
        tableRef.setTableId(options.getBigQueryTable());
        return tableRef;
    }

    public static void main(String[] args) throws IOException {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        options.setBigQuerySchema(WindowedWordCount.getSchema());
        ExampleUtils exampleUtils = new ExampleUtils(options);
        exampleUtils.setup();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)((PCollection)pipeline.apply((PTransform)TextIO.Read.from((String)options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new AddTimestampFn()));
        PCollection windowedWords = (PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)options.getWindowSize().intValue()))));
        PCollection wordCounts = (PCollection)windowedWords.apply((PTransform)new WordCount.CountWords());
        ((PCollection)wordCounts.apply((PTransform)ParDo.of((DoFn)new FormatAsTableRowFn()))).apply((PTransform)BigQueryIO.Write.to((TableReference)WindowedWordCount.getTableReference(options)).withSchema(WindowedWordCount.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        PipelineResult result = pipeline.run();
        exampleUtils.waitToFinish(result);
    }

    public static interface Options
    extends WordCount.WordCountOptions,
    ExampleOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Fixed window duration, in minutes")
        @Default.Integer(value=1)
        public Integer getWindowSize();

        public void setWindowSize(Integer var1);
    }

    static class FormatAsTableRowFn
    extends DoFn<KV<String, Long>, TableRow> {
        FormatAsTableRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            TableRow row = new TableRow().set("word", ((KV)c.element()).getKey()).set("count", ((KV)c.element()).getValue()).set("window_timestamp", (Object)c.timestamp().toString());
            c.output((Object)row);
        }
    }

    static class AddTimestampFn
    extends DoFn<String, String> {
        private static final Duration RAND_RANGE = Duration.standardHours((long)2L);
        private final Instant minTimestamp = new Instant(System.currentTimeMillis());

        AddTimestampFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            long randMillis = (long)(Math.random() * (double)RAND_RANGE.getMillis());
            Instant randomTimestamp = this.minTimestamp.plus(randMillis);
            c.outputWithTimestamp(c.element(), new Instant((Object)randomTimestamp));
        }
    }
}

