/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.RemoveDuplicates;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DeDupExampleTest {
    @Test
    @Category(value={RunnableOnService.class})
    public void testRemoveDuplicates() {
        List<String> strings = Arrays.asList("k1", "k5", "k5", "k2", "k1", "k2", "k3");
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)p.apply((PTransform)Create.of(strings).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)RemoveDuplicates.create());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"k1", "k5", "k2", "k3"});
        p.run();
    }

    @Test
    @Category(value={RunnableOnService.class})
    public void testRemoveDuplicatesEmpty() {
        List<String> strings = Arrays.asList(new String[0]);
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)p.apply((PTransform)Create.of(strings).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)RemoveDuplicates.create());
        PAssert.that((PCollection)output).empty();
        p.run();
    }
}

