/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WordCountTest {
    static final String[] WORDS_ARRAY = new String[]{"hi there", "hi", "hi sue bob", "hi sue", "", "bob hi"};
    static final List<String> WORDS = Arrays.asList(WORDS_ARRAY);
    static final String[] COUNTS_ARRAY = new String[]{"hi: 5", "there: 1", "sue: 2", "bob: 2"};

    @Test
    public void testExtractWordsFn() throws Exception {
        DoFnTester extractWordsFn = DoFnTester.of((DoFn)new WordCount.ExtractWordsFn());
        Assert.assertThat((Object)extractWordsFn.processBundle((Object[])new String[]{" some  input  words "}), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"some", "input", "words"}));
        Assert.assertThat((Object)extractWordsFn.processBundle((Object[])new String[]{" "}), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[0]));
        Assert.assertThat((Object)extractWordsFn.processBundle((Object[])new String[]{" some ", " input", " words"}), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"some", "input", "words"}));
    }

    @Test
    @Category(value={RunnableOnService.class})
    public void testCountWords() throws Exception {
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)p.apply((PTransform)Create.of(WORDS).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)new WordCount.CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new WordCount.FormatAsTextFn()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])COUNTS_ARRAY);
        p.run();
    }
}

