/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Date;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WordCountIT {
    @Test
    public void testE2EWordCount() throws Exception {
        PipelineOptionsFactory.register(WordCountITOptions.class);
        WordCountITOptions options = (WordCountITOptions)TestPipeline.testingPipelineOptions().as(WordCountITOptions.class);
        options.setOutput(IOChannelUtils.resolve((String)options.getTempRoot(), (String[])new String[]{String.format("WordCountIT-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), "output", "results"}));
        options.setOnSuccessMatcher((SerializableMatcher)new FileChecksumMatcher(options.getOutputChecksum(), options.getOutput() + "*"));
        String e2eTestInputPath = "gs://apache-beam-samples/apache/LICENSE";
        options.setInputFile(e2eTestInputPath);
        WordCount.main((String[])TestPipeline.convertToArgs((PipelineOptions)options));
    }

    public static interface WordCountITOptions
    extends TestPipelineOptions,
    WordCount.WordCountOptions {
        @Default.String(value="c04722202dee29c442b55ead54c6000693e85e77")
        public String getOutputChecksum();

        public void setOutputChecksum(String var1);
    }
}

