/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.IOException;
import org.apache.beam.examples.WindowedWordCount;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.testing.BigqueryMatcher;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.testing.StreamingIT;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WindowedWordCountIT {
    @Test
    public void testWindowedWordCountInBatch() throws IOException {
        this.testWindowedWordCountPipeline(false);
    }

    @Test
    @Category(value={StreamingIT.class})
    public void testWindowedWordCountInStreaming() throws IOException {
        this.testWindowedWordCountPipeline(true);
    }

    private void testWindowedWordCountPipeline(boolean isStreaming) throws IOException {
        PipelineOptionsFactory.register(WindowedWordCountITOptions.class);
        WindowedWordCountITOptions options = (WindowedWordCountITOptions)TestPipeline.testingPipelineOptions().as(WindowedWordCountITOptions.class);
        options.setStreaming(isStreaming);
        String query = String.format("SELECT word, SUM(count) FROM [%s:%s.%s] GROUP BY word", options.getProject(), options.getBigQueryDataset(), options.getBigQueryTable());
        options.setOnSuccessMatcher((SerializableMatcher)new BigqueryMatcher(options.getAppName(), options.getProject(), query, options.getChecksum()));
        WindowedWordCount.main((String[])TestPipeline.convertToArgs((PipelineOptions)options));
    }

    public static interface WindowedWordCountITOptions
    extends WindowedWordCount.Options,
    TestPipelineOptions,
    StreamingOptions {
        @Default.String(value="ff54f6f42b2afeb146206c1e8e915deaee0362b4")
        public String getChecksum();

        public void setChecksum(String var1);
    }
}

