/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.DatastoreHelper;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.DatastoreIO;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;

public class DatastoreWordCount {
    static DatastoreV1.Key makeAncestorKey(@Nullable String namespace, String kind) {
        DatastoreV1.Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{kind, "root"});
        if (namespace != null) {
            keyBuilder.getPartitionIdBuilder().setNamespace(namespace);
        }
        return keyBuilder.build();
    }

    public static void writeDataToDatastore(Options options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.named((String)"ReadLines").from(options.getInput()))).apply((PTransform)ParDo.of((DoFn)new CreateEntityFn(options.getNamespace(), options.getKind())))).apply((PTransform)DatastoreIO.writeTo((String)options.getDataset()));
        p.run();
    }

    static DatastoreV1.Query makeAncestorKindQuery(Options options) {
        DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
        q.addKindBuilder().setName(options.getKind());
        q.setFilter(DatastoreHelper.makeFilter((String)"__key__", (DatastoreV1.PropertyFilter.Operator)DatastoreV1.PropertyFilter.Operator.HAS_ANCESTOR, (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((DatastoreV1.Key)DatastoreWordCount.makeAncestorKey(options.getNamespace(), options.getKind()))));
        return q.build();
    }

    public static void readDataFromDatastore(Options options) {
        DatastoreV1.Query query = DatastoreWordCount.makeAncestorKindQuery(options);
        DatastoreIO.Source source = DatastoreIO.source().withDataset(options.getDataset()).withQuery(query).withNamespace(options.getNamespace());
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)p.apply("ReadShakespeareFromDatastore", (PTransform)Read.from((BoundedSource)source))).apply("StringifyEntity", (PTransform)ParDo.of((DoFn)new GetContentFn()))).apply("CountWords", (PTransform)new WordCount.CountWords())).apply("PrintWordCount", (PTransform)MapElements.via((SimpleFunction)new WordCount.FormatAsTextFn()))).apply("WriteLines", (PTransform)TextIO.Write.to((String)options.getOutput()).withNumShards(options.getNumShards()));
        p.run();
    }

    public static void main(String[] args) {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        if (!options.isReadOnly()) {
            DatastoreWordCount.writeDataToDatastore(options);
        }
        DatastoreWordCount.readDataFromDatastore(options);
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Path of the file to read from and store to Datastore")
        @Default.String(value="gs://dataflow-samples/shakespeare/kinglear.txt")
        public String getInput();

        public void setInput(String var1);

        @Description(value="Path of the file to write to")
        @Validation.Required
        public String getOutput();

        public void setOutput(String var1);

        @Description(value="Dataset ID to read from datastore")
        @Validation.Required
        public String getDataset();

        public void setDataset(String var1);

        @Description(value="Dataset entity kind")
        @Default.String(value="shakespeare-demo")
        public String getKind();

        public void setKind(String var1);

        @Description(value="Dataset namespace")
        public String getNamespace();

        public void setNamespace(@Nullable String var1);

        @Description(value="Read an existing dataset, do not write first")
        public boolean isReadOnly();

        public void setReadOnly(boolean var1);

        @Description(value="Number of output shards")
        @Default.Integer(value=0)
        public int getNumShards();

        public void setNumShards(int var1);
    }

    static class CreateEntityFn
    extends DoFn<String, DatastoreV1.Entity> {
        private final String namespace;
        private final String kind;
        private final DatastoreV1.Key ancestorKey;

        CreateEntityFn(String namespace, String kind) {
            this.namespace = namespace;
            this.kind = kind;
            this.ancestorKey = DatastoreWordCount.makeAncestorKey(namespace, kind);
        }

        public DatastoreV1.Entity makeEntity(String content) {
            DatastoreV1.Entity.Builder entityBuilder = DatastoreV1.Entity.newBuilder();
            DatastoreV1.Key.Builder keyBuilder = DatastoreHelper.makeKey((Object[])new Object[]{this.ancestorKey, this.kind, UUID.randomUUID().toString()});
            if (this.namespace != null) {
                keyBuilder.getPartitionIdBuilder().setNamespace(this.namespace);
            }
            entityBuilder.setKey(keyBuilder.build());
            entityBuilder.addProperty(DatastoreV1.Property.newBuilder().setName("content").setValue(DatastoreV1.Value.newBuilder().setStringValue(content)));
            return entityBuilder.build();
        }

        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)this.makeEntity((String)c.element()));
        }
    }

    static class GetContentFn
    extends DoFn<DatastoreV1.Entity, String> {
        GetContentFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            Map props = DatastoreHelper.getPropertyMap((DatastoreV1.EntityOrBuilder)((DatastoreV1.EntityOrBuilder)c.element()));
            DatastoreV1.Value value = (DatastoreV1.Value)props.get("content");
            if (value != null) {
                c.output((Object)DatastoreHelper.getString((DatastoreV1.ValueOrBuilder)value));
            }
        }
    }
}

