/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.examples.common.DataflowExampleUtils;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExamplePubsubTopicOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.BigQueryIO;
import org.apache.beam.sdk.io.DatastoreIO;
import org.apache.beam.sdk.io.PubsubIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.joda.time.Duration;

public class AutoComplete {
    public static void main(String[] args) throws IOException {
        GlobalWindows windowFn;
        TextIO.Read.Bound readSource;
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        options.setBigQuerySchema(FormatForBigquery.getSchema());
        DataflowExampleUtils dataflowUtils = new DataflowExampleUtils(options);
        if (options.isStreaming()) {
            Preconditions.checkArgument((options.getOutputToDatastore() == false ? 1 : 0) != 0, (Object)"DatastoreIO is not supported in streaming.");
            dataflowUtils.setupPubsub();
            readSource = PubsubIO.Read.topic((String)options.getPubsubTopic());
            windowFn = SlidingWindows.of((Duration)Duration.standardMinutes((long)30L)).every(Duration.standardSeconds((long)5L));
        } else {
            readSource = TextIO.Read.from((String)options.getInputFile());
            windowFn = new GlobalWindows();
        }
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection toWrite = (PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)readSource)).apply((PTransform)ParDo.of((DoFn)new ExtractHashtags()))).apply((PTransform)Window.into((WindowFn)windowFn))).apply((PTransform)ComputeTopCompletions.top(10, options.getRecursive()));
        if (options.getOutputToDatastore().booleanValue()) {
            ((PCollection)toWrite.apply((PTransform)ParDo.named((String)"FormatForDatastore").of((DoFn)new FormatForDatastore(options.getKind())))).apply((PTransform)DatastoreIO.writeTo((String)((String)MoreObjects.firstNonNull((Object)options.getOutputDataset(), (Object)options.getProject()))));
        }
        if (options.getOutputToBigQuery().booleanValue()) {
            dataflowUtils.setupBigQueryTable();
            TableReference tableRef = new TableReference();
            tableRef.setProjectId(options.getProject());
            tableRef.setDatasetId(options.getBigQueryDataset());
            tableRef.setTableId(options.getBigQueryTable());
            ((PCollection)toWrite.apply((PTransform)ParDo.of((DoFn)new FormatForBigquery()))).apply((PTransform)BigQueryIO.Write.to((TableReference)tableRef).withSchema(FormatForBigquery.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        }
        PipelineResult result = p.run();
        if (options.isStreaming() && !options.getInputFile().isEmpty()) {
            dataflowUtils.runInjectorPipeline(options.getInputFile(), options.getPubsubTopic());
        }
        dataflowUtils.waitToFinish(result);
    }

    private static interface Options
    extends ExamplePubsubTopicOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Input text file")
        public String getInputFile();

        public void setInputFile(String var1);

        @Description(value="Whether to use the recursive algorithm")
        @Default.Boolean(value=true)
        public Boolean getRecursive();

        public void setRecursive(Boolean var1);

        @Description(value="Dataset entity kind")
        @Default.String(value="autocomplete-demo")
        public String getKind();

        public void setKind(String var1);

        @Description(value="Whether output to BigQuery")
        @Default.Boolean(value=true)
        public Boolean getOutputToBigQuery();

        public void setOutputToBigQuery(Boolean var1);

        @Description(value="Whether output to Datastore")
        @Default.Boolean(value=false)
        public Boolean getOutputToDatastore();

        public void setOutputToDatastore(Boolean var1);

        @Description(value="Datastore output dataset ID, defaults to project ID")
        public String getOutputDataset();

        public void setOutputDataset(String var1);
    }

    static class FormatForDatastore
    extends DoFn<KV<String, List<CompletionCandidate>>, DatastoreV1.Entity> {
        private String kind;

        public FormatForDatastore(String kind) {
            this.kind = kind;
        }

        public void processElement(DoFn.ProcessContext c) {
            DatastoreV1.Entity.Builder entityBuilder = DatastoreV1.Entity.newBuilder();
            DatastoreV1.Key key = DatastoreHelper.makeKey((Object[])new Object[]{this.kind, ((KV)c.element()).getKey()}).build();
            entityBuilder.setKey(key);
            ArrayList<DatastoreV1.Value> candidates = new ArrayList<DatastoreV1.Value>();
            for (CompletionCandidate tag : (List)((KV)c.element()).getValue()) {
                DatastoreV1.Entity.Builder tagEntity = DatastoreV1.Entity.newBuilder();
                tagEntity.addProperty(DatastoreHelper.makeProperty((String)"tag", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((String)tag.value)));
                tagEntity.addProperty(DatastoreHelper.makeProperty((String)"count", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue((long)tag.count)));
                candidates.add(DatastoreHelper.makeValue((DatastoreV1.Entity.Builder)tagEntity).setIndexed(false).build());
            }
            entityBuilder.addProperty(DatastoreHelper.makeProperty((String)"candidates", (DatastoreV1.Value.Builder)DatastoreHelper.makeValue(candidates)));
            c.output((Object)entityBuilder.build());
        }
    }

    static class FormatForBigquery
    extends DoFn<KV<String, List<CompletionCandidate>>, TableRow> {
        FormatForBigquery() {
        }

        public void processElement(DoFn.ProcessContext c) {
            ArrayList<TableRow> completions = new ArrayList<TableRow>();
            for (CompletionCandidate cc : (List)((KV)c.element()).getValue()) {
                completions.add(new TableRow().set("count", (Object)cc.getCount()).set("tag", (Object)cc.getValue()));
            }
            TableRow row = new TableRow().set("prefix", ((KV)c.element()).getKey()).set("tags", completions);
            c.output((Object)row);
        }

        static TableSchema getSchema() {
            ArrayList<TableFieldSchema> tagFields = new ArrayList<TableFieldSchema>();
            tagFields.add(new TableFieldSchema().setName("count").setType("INTEGER"));
            tagFields.add(new TableFieldSchema().setName("tag").setType("STRING"));
            ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
            fields.add(new TableFieldSchema().setName("prefix").setType("STRING"));
            fields.add(new TableFieldSchema().setName("tags").setType("RECORD").setMode("REPEATED").setFields(tagFields));
            return new TableSchema().setFields(fields);
        }
    }

    static class ExtractHashtags
    extends DoFn<String, String> {
        ExtractHashtags() {
        }

        public void processElement(DoFn.ProcessContext c) {
            Matcher m = Pattern.compile("#\\S+").matcher((CharSequence)c.element());
            while (m.find()) {
                c.output((Object)m.group().substring(1));
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class CompletionCandidate
    implements Comparable<CompletionCandidate> {
        private long count;
        private String value;

        public CompletionCandidate(String value, long count) {
            this.value = value;
            this.count = count;
        }

        public long getCount() {
            return this.count;
        }

        public String getValue() {
            return this.value;
        }

        public CompletionCandidate() {
        }

        @Override
        public int compareTo(CompletionCandidate o) {
            if (this.count < o.count) {
                return -1;
            }
            if (this.count == o.count) {
                return this.value.compareTo(o.value);
            }
            return 1;
        }

        public boolean equals(Object other) {
            if (other instanceof CompletionCandidate) {
                CompletionCandidate that = (CompletionCandidate)other;
                return this.count == that.count && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.count).hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            String string = this.value;
            long l = this.count;
            return new StringBuilder(43 + String.valueOf(string).length()).append("CompletionCandidate[").append(string).append(", ").append(l).append("]").toString();
        }
    }

    private static class AllPrefixes
    extends DoFn<CompletionCandidate, KV<String, CompletionCandidate>> {
        private final int minPrefix;
        private final int maxPrefix;

        public AllPrefixes(int minPrefix) {
            this(minPrefix, Integer.MAX_VALUE);
        }

        public AllPrefixes(int minPrefix, int maxPrefix) {
            this.minPrefix = minPrefix;
            this.maxPrefix = maxPrefix;
        }

        public void processElement(DoFn.ProcessContext c) {
            String word = ((CompletionCandidate)c.element()).value;
            for (int i = this.minPrefix; i <= Math.min(word.length(), this.maxPrefix); ++i) {
                c.output((Object)KV.of((Object)word.substring(0, i), (Object)c.element()));
            }
        }
    }

    private static class ComputeTopRecursive
    extends PTransform<PCollection<CompletionCandidate>, PCollectionList<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopRecursive(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollectionList<KV<String, List<CompletionCandidate>>> apply(PCollection<CompletionCandidate> input) {
            if (this.minPrefix > 10) {
                return (PCollectionList)((PCollection)input.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, this.minPrefix))).apply((PTransform)Partition.of((int)2, (Partition.PartitionFn)new KeySizePartitionFn()));
            }
            PCollectionList larger = (PCollectionList)input.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, this.minPrefix + 1));
            PCollection small = (PCollection)((PCollection)((PCollection)PCollectionList.of((PCollection)((PCollection)larger.get(1).apply((PTransform)ParDo.of((DoFn)new FlattenTops())))).and((PCollection)input.apply((PTransform)Filter.byPredicate((SerializableFunction)new SerializableFunction<CompletionCandidate, Boolean>(){

                public Boolean apply(CompletionCandidate c) {
                    return c.getValue().length() == ComputeTopRecursive.this.minPrefix;
                }
            }))).apply("FlattenSmall", (PTransform)Flatten.pCollections())).apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix, this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix));
            PCollection flattenLarger = (PCollection)larger.apply("FlattenLarge", (PTransform)Flatten.pCollections());
            return PCollectionList.of((PCollection)flattenLarger).and(small);
        }

        private static class FlattenTops
        extends DoFn<KV<String, List<CompletionCandidate>>, CompletionCandidate> {
            private FlattenTops() {
            }

            public void processElement(DoFn.ProcessContext c) {
                for (CompletionCandidate cc : (List)((KV)c.element()).getValue()) {
                    c.output((Object)cc);
                }
            }
        }

        private class KeySizePartitionFn
        implements Partition.PartitionFn<KV<String, List<CompletionCandidate>>> {
            private KeySizePartitionFn() {
            }

            public int partitionFor(KV<String, List<CompletionCandidate>> elem, int numPartitions) {
                return ((String)elem.getKey()).length() > ComputeTopRecursive.this.minPrefix ? 0 : 1;
            }
        }
    }

    private static class ComputeTopFlat
    extends PTransform<PCollection<CompletionCandidate>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final int minPrefix;

        public ComputeTopFlat(int candidatesPerPrefix, int minPrefix) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.minPrefix = minPrefix;
        }

        public PCollection<KV<String, List<CompletionCandidate>>> apply(PCollection<CompletionCandidate> input) {
            return (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new AllPrefixes(this.minPrefix)))).apply((PTransform)Top.largestPerKey((int)this.candidatesPerPrefix).withHotKeyFanout((SerializableFunction)new HotKeyFanout()));
        }

        private static class HotKeyFanout
        implements SerializableFunction<String, Integer> {
            private HotKeyFanout() {
            }

            public Integer apply(String input) {
                return (int)Math.pow(4.0, 5 - input.length());
            }
        }
    }

    public static class ComputeTopCompletions
    extends PTransform<PCollection<String>, PCollection<KV<String, List<CompletionCandidate>>>> {
        private final int candidatesPerPrefix;
        private final boolean recursive;

        protected ComputeTopCompletions(int candidatesPerPrefix, boolean recursive) {
            this.candidatesPerPrefix = candidatesPerPrefix;
            this.recursive = recursive;
        }

        public static ComputeTopCompletions top(int candidatesPerPrefix, boolean recursive) {
            return new ComputeTopCompletions(candidatesPerPrefix, recursive);
        }

        public PCollection<KV<String, List<CompletionCandidate>>> apply(PCollection<String> input) {
            PCollection candidates = (PCollection)((PCollection)input.apply((PTransform)new Count.PerElement())).apply((PTransform)ParDo.named((String)"CreateCompletionCandidates").of((DoFn)new DoFn<KV<String, Long>, CompletionCandidate>(){

                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)new CompletionCandidate((String)((KV)c.element()).getKey(), (Long)((KV)c.element()).getValue()));
                }
            }));
            if (this.recursive) {
                return (PCollection)((PCollectionList)candidates.apply((PTransform)new ComputeTopRecursive(this.candidatesPerPrefix, 1))).apply((PTransform)Flatten.pCollections());
            }
            return (PCollection)candidates.apply((PTransform)new ComputeTopFlat(this.candidatesPerPrefix, 1));
        }
    }
}

