/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.common;

import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PubsubOptions;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.IntraBundleParallelization;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.values.PCollection;

public class PubsubFileInjector {
    public static Unbound withTimestampLabelKey(String timestampLabelKey) {
        return new Unbound(timestampLabelKey);
    }

    public static Bound publish(String outputTopic) {
        return new Unbound().publish(outputTopic);
    }

    public static void main(String[] args) {
        PubsubFileInjectorOptions options = (PubsubFileInjectorOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(PubsubFileInjectorOptions.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)TextIO.Read.from((String)options.getInput()))).apply((PTransform)IntraBundleParallelization.of((DoFn)PubsubFileInjector.publish(options.getOutputTopic())).withMaxParallelism(20));
        pipeline.run();
    }

    private static interface PubsubFileInjectorOptions
    extends PipelineOptions {
        @Description(value="GCS location of files.")
        @Validation.Required
        public String getInput();

        public void setInput(String var1);

        @Description(value="Topic to publish on.")
        @Validation.Required
        public String getOutputTopic();

        public void setOutputTopic(String var1);
    }

    public static class Bound
    extends DoFn<String, Void> {
        private final String outputTopic;
        private final String timestampLabelKey;
        public transient Pubsub pubsub;

        public Bound(String outputTopic, String timestampLabelKey) {
            this.outputTopic = outputTopic;
            this.timestampLabelKey = timestampLabelKey;
        }

        public void startBundle(DoFn.Context context) {
            this.pubsub = Transport.newPubsubClient((PubsubOptions)((PubsubOptions)context.getPipelineOptions().as(DataflowPipelineOptions.class))).build();
        }

        public void processElement(DoFn.ProcessContext c) throws IOException {
            if (((String)c.element()).isEmpty()) {
                return;
            }
            PubsubMessage pubsubMessage = new PubsubMessage();
            pubsubMessage.encodeData(((String)c.element()).getBytes());
            if (this.timestampLabelKey != null) {
                pubsubMessage.setAttributes((Map)ImmutableMap.of((Object)this.timestampLabelKey, (Object)Long.toString(c.timestamp().getMillis())));
            }
            PublishRequest publishRequest = new PublishRequest();
            publishRequest.setMessages(Arrays.asList(pubsubMessage));
            this.pubsub.projects().topics().publish(this.outputTopic, publishRequest).execute();
        }
    }

    public static class Unbound {
        private final String timestampLabelKey;

        Unbound() {
            this.timestampLabelKey = null;
        }

        Unbound(String timestampLabelKey) {
            this.timestampLabelKey = timestampLabelKey;
        }

        Unbound withTimestampLabelKey(String timestampLabelKey) {
            return new Unbound(timestampLabelKey);
        }

        public Bound publish(String outputTopic) {
            return new Bound(outputTopic, this.timestampLabelKey);
        }
    }
}

