/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.common;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.beam.examples.common.DataflowExampleOptions;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExamplePubsubTopicAndSubscriptionOptions;
import org.apache.beam.examples.common.ExamplePubsubTopicOptions;
import org.apache.beam.examples.common.PubsubFileInjector;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.BigQueryOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PubsubOptions;
import org.apache.beam.sdk.runners.DirectPipelineRunner;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.IntraBundleParallelization;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AttemptBoundedExponentialBackOff;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;

public class DataflowExampleUtils {
    private final DataflowPipelineOptions options;
    private Bigquery bigQueryClient = null;
    private Pubsub pubsubClient = null;
    private Dataflow dataflowClient = null;
    private Set<DataflowPipelineJob> jobsToCancel = Sets.newHashSet();
    private List<String> pendingMessages = Lists.newArrayList();

    public DataflowExampleUtils(DataflowPipelineOptions options) {
        this.options = options;
    }

    public DataflowExampleUtils(DataflowPipelineOptions options, boolean isUnbounded) throws IOException {
        this.options = options;
        this.setupResourcesAndRunner(isUnbounded);
    }

    public void setup() throws IOException {
        Sleeper sleeper = Sleeper.DEFAULT;
        AttemptBoundedExponentialBackOff backOff = new AttemptBoundedExponentialBackOff(3, 200L);
        GoogleJsonResponseException lastException = null;
        try {
            while (true) {
                try {
                    this.setupPubsub();
                    this.setupBigQueryTable();
                    return;
                }
                catch (GoogleJsonResponseException e) {
                    lastException = e;
                    if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff)) continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new RuntimeException(lastException);
    }

    public void setupResourcesAndRunner(boolean isUnbounded) throws IOException {
        if (isUnbounded) {
            this.options.setStreaming(true);
        }
        this.setup();
        this.setupRunner();
    }

    public void setupPubsub() throws IOException {
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)this.options.as(ExamplePubsubTopicAndSubscriptionOptions.class);
        if (!pubsubOptions.getPubsubTopic().isEmpty()) {
            this.pendingMessages.add("**********************Set Up Pubsub************************");
            this.setupPubsubTopic(pubsubOptions.getPubsubTopic());
            String string = String.valueOf(pubsubOptions.getPubsubTopic());
            this.pendingMessages.add(string.length() != 0 ? "The Pub/Sub topic has been set up for this example: ".concat(string) : new String("The Pub/Sub topic has been set up for this example: "));
            if (!pubsubOptions.getPubsubSubscription().isEmpty()) {
                this.setupPubsubSubscription(pubsubOptions.getPubsubTopic(), pubsubOptions.getPubsubSubscription());
                String string2 = String.valueOf(pubsubOptions.getPubsubSubscription());
                this.pendingMessages.add(string2.length() != 0 ? "The Pub/Sub subscription has been set up for this example: ".concat(string2) : new String("The Pub/Sub subscription has been set up for this example: "));
            }
        }
    }

    public void setupBigQueryTable() throws IOException {
        ExampleBigQueryTableOptions bigQueryTableOptions = (ExampleBigQueryTableOptions)this.options.as(ExampleBigQueryTableOptions.class);
        if (bigQueryTableOptions.getBigQueryDataset() != null && bigQueryTableOptions.getBigQueryTable() != null && bigQueryTableOptions.getBigQuerySchema() != null) {
            this.pendingMessages.add("******************Set Up Big Query Table*******************");
            this.setupBigQueryTable(bigQueryTableOptions.getProject(), bigQueryTableOptions.getBigQueryDataset(), bigQueryTableOptions.getBigQueryTable(), bigQueryTableOptions.getBigQuerySchema());
            String string = String.valueOf(bigQueryTableOptions.getProject());
            String string2 = bigQueryTableOptions.getBigQueryDataset();
            String string3 = bigQueryTableOptions.getBigQueryTable();
            this.pendingMessages.add(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("The BigQuery table has been set up for this example: ").append(string).append(":").append(string2).append(".").append(string3).toString());
        }
    }

    private void tearDown() {
        ExampleBigQueryTableOptions bigQueryTableOptions;
        this.pendingMessages.add("*************************Tear Down*************************");
        ExamplePubsubTopicAndSubscriptionOptions pubsubOptions = (ExamplePubsubTopicAndSubscriptionOptions)this.options.as(ExamplePubsubTopicAndSubscriptionOptions.class);
        if (!pubsubOptions.getPubsubTopic().isEmpty()) {
            try {
                this.deletePubsubTopic(pubsubOptions.getPubsubTopic());
                String string = String.valueOf(pubsubOptions.getPubsubTopic());
                this.pendingMessages.add(string.length() != 0 ? "The Pub/Sub topic has been deleted: ".concat(string) : new String("The Pub/Sub topic has been deleted: "));
            }
            catch (IOException e) {
                String string = String.valueOf(pubsubOptions.getPubsubTopic());
                this.pendingMessages.add(string.length() != 0 ? "Failed to delete the Pub/Sub topic : ".concat(string) : new String("Failed to delete the Pub/Sub topic : "));
            }
            if (!pubsubOptions.getPubsubSubscription().isEmpty()) {
                try {
                    this.deletePubsubSubscription(pubsubOptions.getPubsubSubscription());
                    String string = String.valueOf(pubsubOptions.getPubsubSubscription());
                    this.pendingMessages.add(string.length() != 0 ? "The Pub/Sub subscription has been deleted: ".concat(string) : new String("The Pub/Sub subscription has been deleted: "));
                }
                catch (IOException e) {
                    String string = String.valueOf(pubsubOptions.getPubsubSubscription());
                    this.pendingMessages.add(string.length() != 0 ? "Failed to delete the Pub/Sub subscription : ".concat(string) : new String("Failed to delete the Pub/Sub subscription : "));
                }
            }
        }
        if ((bigQueryTableOptions = (ExampleBigQueryTableOptions)this.options.as(ExampleBigQueryTableOptions.class)).getBigQueryDataset() != null && bigQueryTableOptions.getBigQueryTable() != null && bigQueryTableOptions.getBigQuerySchema() != null) {
            String string = String.valueOf("The BigQuery table might contain the example's output, and it is not deleted automatically: ");
            String string2 = String.valueOf(bigQueryTableOptions.getProject());
            String string3 = bigQueryTableOptions.getBigQueryDataset();
            String string4 = bigQueryTableOptions.getBigQueryTable();
            this.pendingMessages.add(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append(":").append(string3).append(".").append(string4).toString());
            this.pendingMessages.add("Please go to the Developers Console to delete it manually. Otherwise, you may be charged for its usage.");
        }
    }

    private void setupBigQueryTable(String projectId, String datasetId, String tableId, TableSchema schema) throws IOException {
        Bigquery.Tables tableService;
        Table table;
        Bigquery.Datasets datasetService;
        if (this.bigQueryClient == null) {
            this.bigQueryClient = Transport.newBigQueryClient((BigQueryOptions)((BigQueryOptions)this.options.as(BigQueryOptions.class))).build();
        }
        if (DataflowExampleUtils.executeNullIfNotFound((datasetService = this.bigQueryClient.datasets()).get(projectId, datasetId)) == null) {
            Dataset newDataset = new Dataset().setDatasetReference(new DatasetReference().setProjectId(projectId).setDatasetId(datasetId));
            datasetService.insert(projectId, newDataset).execute();
        }
        if ((table = (Table)DataflowExampleUtils.executeNullIfNotFound((tableService = this.bigQueryClient.tables()).get(projectId, datasetId, tableId))) == null) {
            Table newTable = new Table().setSchema(schema).setTableReference(new TableReference().setProjectId(projectId).setDatasetId(datasetId).setTableId(tableId));
            tableService.insert(projectId, datasetId, newTable).execute();
        } else if (!table.getSchema().equals((Object)schema)) {
            String string = String.valueOf(schema.toPrettyString());
            String string2 = String.valueOf(table.getSchema().toPrettyString());
            throw new RuntimeException(new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Table exists and schemas do not match, expecting: ").append(string).append(", actual: ").append(string2).toString());
        }
    }

    private void setupPubsubTopic(String topic) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = Transport.newPubsubClient((PubsubOptions)this.options).build();
        }
        if (DataflowExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().topics().get(topic)) == null) {
            this.pubsubClient.projects().topics().create(topic, new Topic().setName(topic)).execute();
        }
    }

    private void setupPubsubSubscription(String topic, String subscription) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = Transport.newPubsubClient((PubsubOptions)this.options).build();
        }
        if (DataflowExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().subscriptions().get(subscription)) == null) {
            Subscription subInfo = new Subscription().setAckDeadlineSeconds(Integer.valueOf(60)).setTopic(topic);
            this.pubsubClient.projects().subscriptions().create(subscription, subInfo).execute();
        }
    }

    private void deletePubsubTopic(String topic) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = Transport.newPubsubClient((PubsubOptions)this.options).build();
        }
        if (DataflowExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().topics().get(topic)) != null) {
            this.pubsubClient.projects().topics().delete(topic).execute();
        }
    }

    private void deletePubsubSubscription(String subscription) throws IOException {
        if (this.pubsubClient == null) {
            this.pubsubClient = Transport.newPubsubClient((PubsubOptions)this.options).build();
        }
        if (DataflowExampleUtils.executeNullIfNotFound(this.pubsubClient.projects().subscriptions().get(subscription)) != null) {
            this.pubsubClient.projects().subscriptions().delete(subscription).execute();
        }
    }

    public void startInjectorIfNeeded(String inputFile) {
        ExamplePubsubTopicOptions pubsubTopicOptions = (ExamplePubsubTopicOptions)this.options.as(ExamplePubsubTopicOptions.class);
        if (pubsubTopicOptions.isStreaming() && !Strings.isNullOrEmpty((String)inputFile) && !Strings.isNullOrEmpty((String)pubsubTopicOptions.getPubsubTopic())) {
            this.runInjectorPipeline(inputFile, pubsubTopicOptions.getPubsubTopic());
        }
    }

    public void setupRunner() {
        if (this.options.isStreaming() && this.options.getRunner() != DirectPipelineRunner.class) {
            this.options.setRunner(DataflowPipelineRunner.class);
        }
    }

    public void runInjectorPipeline(String inputFile, String topic) {
        this.runInjectorPipeline((PTransform<? super PBegin, PCollection<String>>)TextIO.Read.from((String)inputFile), topic, null);
    }

    public void runInjectorPipeline(PTransform<? super PBegin, PCollection<String>> readSource, String topic, String pubsubTimestampTabelKey) {
        PubsubFileInjector.Bound injector = Strings.isNullOrEmpty((String)pubsubTimestampTabelKey) ? PubsubFileInjector.publish(topic) : PubsubFileInjector.withTimestampLabelKey(pubsubTimestampTabelKey).publish(topic);
        DataflowPipelineOptions copiedOptions = (DataflowPipelineOptions)this.options.cloneAs(DataflowPipelineOptions.class);
        if (this.options.getServiceAccountName() != null) {
            copiedOptions.setServiceAccountName(this.options.getServiceAccountName());
        }
        if (this.options.getServiceAccountKeyfile() != null) {
            copiedOptions.setServiceAccountKeyfile(this.options.getServiceAccountKeyfile());
        }
        copiedOptions.setStreaming(false);
        copiedOptions.setWorkerHarnessContainerImage("dataflow.gcr.io/v1beta3/beam-java-batch:beam-master-20160427");
        copiedOptions.setNumWorkers(((DataflowExampleOptions)this.options.as(DataflowExampleOptions.class)).getInjectorNumWorkers());
        copiedOptions.setJobName(String.valueOf(this.options.getJobName()).concat("-injector"));
        Pipeline injectorPipeline = Pipeline.create((PipelineOptions)copiedOptions);
        ((PCollection)injectorPipeline.apply(readSource)).apply((PTransform)IntraBundleParallelization.of((DoFn)injector).withMaxParallelism(20));
        PipelineResult result = injectorPipeline.run();
        if (result instanceof DataflowPipelineJob) {
            this.jobsToCancel.add((DataflowPipelineJob)result);
        }
    }

    public void runInjectorPipeline(Pipeline injectorPipeline) {
        PipelineResult result = injectorPipeline.run();
        if (result instanceof DataflowPipelineJob) {
            this.jobsToCancel.add((DataflowPipelineJob)result);
        }
    }

    public void mockUnboundedSource(String inputFile, PipelineResult result) {
        this.startInjectorIfNeeded(inputFile);
        this.waitToFinish(result);
    }

    public void waitToFinish(PipelineResult result) {
        if (result instanceof DataflowPipelineJob) {
            DataflowPipelineJob job = (DataflowPipelineJob)result;
            this.jobsToCancel.add(job);
            if (!((DataflowExampleOptions)this.options.as(DataflowExampleOptions.class)).getKeepJobsRunning()) {
                this.addShutdownHook(this.jobsToCancel);
            }
            try {
                job.waitToFinish(-1L, TimeUnit.SECONDS, (MonitoringUtil.JobMessagesHandler)new MonitoringUtil.PrintHandler(System.out));
            }
            catch (Exception e) {
                String string = String.valueOf(job.getJobId());
                throw new RuntimeException(string.length() != 0 ? "Failed to wait for job to finish: ".concat(string) : new String("Failed to wait for job to finish: "));
            }
        } else {
            this.tearDown();
            this.printPendingMessages();
        }
    }

    private void addShutdownHook(final Collection<DataflowPipelineJob> jobs) {
        if (this.dataflowClient == null) {
            this.dataflowClient = this.options.getDataflowClient();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DataflowExampleUtils.this.tearDown();
                DataflowExampleUtils.this.printPendingMessages();
                for (DataflowPipelineJob job : jobs) {
                    String string = String.valueOf(job.getJobId());
                    System.out.println(string.length() != 0 ? "Canceling example pipeline: ".concat(string) : new String("Canceling example pipeline: "));
                    try {
                        job.cancel();
                    }
                    catch (IOException e) {
                        System.out.println("Failed to cancel the job, please go to the Developers Console to cancel it manually");
                        System.out.println(MonitoringUtil.getJobMonitoringPageURL((String)job.getProjectId(), (String)job.getJobId()));
                    }
                }
                for (DataflowPipelineJob job : jobs) {
                    boolean cancellationVerified = false;
                    for (int retryAttempts = 6; retryAttempts > 0; --retryAttempts) {
                        if (job.getState().isTerminal()) {
                            cancellationVerified = true;
                            String string = String.valueOf(job.getJobId());
                            System.out.println(string.length() != 0 ? "Canceled example pipeline: ".concat(string) : new String("Canceled example pipeline: "));
                            break;
                        }
                        System.out.println("The example pipeline is still running. Verifying the cancellation.");
                        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    if (cancellationVerified) continue;
                    String string = String.valueOf(job.getJobId());
                    System.out.println(string.length() != 0 ? "Failed to verify the cancellation for job: ".concat(string) : new String("Failed to verify the cancellation for job: "));
                    System.out.println("Please go to the Developers Console to verify manually:");
                    System.out.println(MonitoringUtil.getJobMonitoringPageURL((String)job.getProjectId(), (String)job.getJobId()));
                }
            }
        });
    }

    private void printPendingMessages() {
        System.out.println();
        System.out.println("***********************************************************");
        System.out.println("***********************************************************");
        for (String message : this.pendingMessages) {
            System.out.println(message);
        }
        System.out.println("***********************************************************");
        System.out.println("***********************************************************");
    }

    private static <T> T executeNullIfNotFound(AbstractGoogleClientRequest<T> request) throws IOException {
        try {
            return (T)request.execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }
}

