/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class WordCount {
    public static void main(String[] args) {
        WordCountOptions options = (WordCountOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(WordCountOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.named((String)"ReadLines").from(options.getInputFile()))).apply((PTransform)new CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new FormatAsTextFn()))).apply((PTransform)TextIO.Write.named((String)"WriteCounts").to(options.getOutput()));
        p.run();
    }

    public static interface WordCountOptions
    extends PipelineOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://dataflow-samples/shakespeare/kinglear.txt")
        public String getInputFile();

        public void setInputFile(String var1);

        @Description(value="Path of the file to write to")
        @Default.InstanceFactory(value=OutputFactory.class)
        public String getOutput();

        public void setOutput(String var1);

        public static class OutputFactory
        implements DefaultValueFactory<String> {
            public String create(PipelineOptions options) {
                if (options.getTempLocation() != null) {
                    return GcsPath.fromUri((String)options.getTempLocation()).resolve("counts.txt").toString();
                }
                throw new IllegalArgumentException("Must specify --output or --tempLocation");
            }
        }
    }

    public static class CountWords
    extends PTransform<PCollection<String>, PCollection<KV<String, Long>>> {
        public PCollection<KV<String, Long>> apply(PCollection<String> lines) {
            PCollection words = (PCollection)lines.apply((PTransform)ParDo.of((DoFn)new ExtractWordsFn()));
            PCollection wordCounts = (PCollection)words.apply((PTransform)Count.perElement());
            return wordCounts;
        }
    }

    public static class FormatAsTextFn
    extends SimpleFunction<KV<String, Long>, String> {
        public String apply(KV<String, Long> input) {
            String string = (String)input.getKey();
            String string2 = String.valueOf(input.getValue());
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
        }
    }

    static class ExtractWordsFn
    extends DoFn<String, String> {
        private final Aggregator<Long, Long> emptyLines = this.createAggregator("emptyLines", (Combine.CombineFn)new Sum.SumLongFn());

        ExtractWordsFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            String[] words;
            if (((String)c.element()).trim().isEmpty()) {
                this.emptyLines.addValue((Object)1L);
            }
            for (String word : words = ((String)c.element()).split("[^a-zA-Z']+")) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }
}

