/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.beam.examples.WordCount;
import org.apache.beam.examples.common.DataflowExampleOptions;
import org.apache.beam.examples.common.DataflowExampleUtils;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExamplePubsubTopicOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.BigQueryIO;
import org.apache.beam.sdk.io.PubsubIO;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowedWordCount {
    private static final Logger LOG = LoggerFactory.getLogger(WindowedWordCount.class);
    static final int WINDOW_SIZE = 1;

    private static TableSchema getSchema() {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("word").setType("STRING"));
        fields.add(new TableFieldSchema().setName("count").setType("INTEGER"));
        fields.add(new TableFieldSchema().setName("window_timestamp").setType("TIMESTAMP"));
        TableSchema schema = new TableSchema().setFields(fields);
        return schema;
    }

    private static TableReference getTableReference(Options options) {
        TableReference tableRef = new TableReference();
        tableRef.setProjectId(options.getProject());
        tableRef.setDatasetId(options.getBigQueryDataset());
        tableRef.setTableId(options.getBigQueryTable());
        return tableRef;
    }

    public static void main(String[] args) throws IOException {
        PCollection input;
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        options.setBigQuerySchema(WindowedWordCount.getSchema());
        DataflowExampleUtils exampleDataflowUtils = new DataflowExampleUtils(options, options.isUnbounded());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        if (options.isUnbounded()) {
            LOG.info("Reading from PubSub.");
            input = (PCollection)pipeline.apply((PTransform)PubsubIO.Read.topic((String)options.getPubsubTopic()));
        } else {
            input = (PCollection)((PCollection)pipeline.apply((PTransform)TextIO.Read.from((String)options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new AddTimestampFn()));
        }
        PCollection windowedWords = (PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)options.getWindowSize().intValue()))));
        PCollection wordCounts = (PCollection)windowedWords.apply((PTransform)new WordCount.CountWords());
        ((PCollection)wordCounts.apply((PTransform)ParDo.of((DoFn)new FormatAsTableRowFn()))).apply((PTransform)BigQueryIO.Write.to((TableReference)WindowedWordCount.getTableReference(options)).withSchema(WindowedWordCount.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        PipelineResult result = pipeline.run();
        exampleDataflowUtils.mockUnboundedSource(options.getInputFile(), result);
    }

    public static interface Options
    extends WordCount.WordCountOptions,
    DataflowExampleOptions,
    ExamplePubsubTopicOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Fixed window duration, in minutes")
        @Default.Integer(value=1)
        public Integer getWindowSize();

        public void setWindowSize(Integer var1);

        @Description(value="Whether to run the pipeline with unbounded input")
        public boolean isUnbounded();

        public void setUnbounded(boolean var1);
    }

    static class FormatAsTableRowFn
    extends DoFn<KV<String, Long>, TableRow> {
        FormatAsTableRowFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            TableRow row = new TableRow().set("word", ((KV)c.element()).getKey()).set("count", ((KV)c.element()).getValue()).set("window_timestamp", (Object)c.timestamp().toString());
            c.output((Object)row);
        }
    }

    static class AddTimestampFn
    extends DoFn<String, String> {
        private static final long RAND_RANGE = 0x6DDD00L;

        AddTimestampFn() {
        }

        public void processElement(DoFn.ProcessContext c) {
            long randomTimestamp = System.currentTimeMillis() - (long)((int)(Math.random() * 7200000.0));
            c.outputWithTimestamp(c.element(), new Instant(randomTimestamp));
        }
    }
}

