/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import org.apache.beam.runners.dataflow.BlockingDataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class MinimalWordCount {
    public static void main(String[] args) {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setRunner(BlockingDataflowPipelineRunner.class);
        options.setProject("SET_YOUR_PROJECT_ID_HERE");
        options.setTempLocation("gs://SET_YOUR_BUCKET_NAME_HERE/AND_TEMP_DIRECTORY");
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.from((String)"gs://dataflow-samples/shakespeare/*"))).apply((PTransform)ParDo.named((String)"ExtractWords").of((DoFn)new DoFn<String, String>(){

            public void processElement(DoFn.ProcessContext c) {
                for (String word : ((String)c.element()).split("[^a-zA-Z']+")) {
                    if (word.isEmpty()) continue;
                    c.output((Object)word);
                }
            }
        }))).apply((PTransform)Count.perElement())).apply("FormatResults", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<KV<String, Long>, String>(){

            public String apply(KV<String, Long> input) {
                String string = (String)input.getKey();
                String string2 = String.valueOf(input.getValue());
                return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
            }
        }))).apply((PTransform)TextIO.Write.to((String)"gs://YOUR_OUTPUT_BUCKET/AND_OUTPUT_PREFIX"));
        p.run();
    }
}

