/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Aggregator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggingWordCount {
    public static void main(String[] args) {
        WordCountOptions options = (WordCountOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(WordCountOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection filteredWords = (PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.Read.named((String)"ReadLines").from(options.getInputFile()))).apply((PTransform)new WordCount.CountWords())).apply((PTransform)ParDo.of((DoFn)new FilterTextFn(options.getFilterPattern())));
        List<KV> expectedResults = Arrays.asList(KV.of((Object)"Flourish", (Object)3L), KV.of((Object)"stomach", (Object)1L));
        PAssert.that((PCollection)filteredWords).containsInAnyOrder(expectedResults);
        p.run();
    }

    public static interface WordCountOptions
    extends WordCount.WordCountOptions {
        @Description(value="Regex filter pattern to use in DebuggingWordCount. Only words matching this pattern will be counted.")
        @Default.String(value="Flourish|stomach")
        public String getFilterPattern();

        public void setFilterPattern(String var1);
    }

    public static class FilterTextFn
    extends DoFn<KV<String, Long>, KV<String, Long>> {
        private static final Logger LOG = LoggerFactory.getLogger(FilterTextFn.class);
        private final Pattern filter;
        private final Aggregator<Long, Long> matchedWords = this.createAggregator("matchedWords", (Combine.CombineFn)new Sum.SumLongFn());
        private final Aggregator<Long, Long> unmatchedWords = this.createAggregator("umatchedWords", (Combine.CombineFn)new Sum.SumLongFn());

        public FilterTextFn(String pattern) {
            this.filter = Pattern.compile(pattern);
        }

        public void processElement(DoFn.ProcessContext c) {
            if (this.filter.matcher((CharSequence)((KV)c.element()).getKey()).matches()) {
                String string = String.valueOf((String)((KV)c.element()).getKey());
                LOG.debug(string.length() != 0 ? "Matched: ".concat(string) : new String("Matched: "));
                this.matchedWords.addValue((Object)1L);
                c.output(c.element());
            } else {
                String string = String.valueOf((String)((KV)c.element()).getKey());
                LOG.trace(string.length() != 0 ? "Did not match: ".concat(string) : new String("Did not match: "));
                this.unmatchedWords.addValue((Object)1L);
            }
        }
    }
}

