/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.examples.cookbook.CombinePerKeyExamples;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CombinePerKeyExamplesTest {
    private static final TableRow row1 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"snuffleupaguses");
    private static final TableRow row2 = new TableRow().set("corpus", (Object)"macbeth").set("word", (Object)"antidisestablishmentarianism");
    private static final TableRow row3 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"antidisestablishmentarianism");
    private static final TableRow row4 = new TableRow().set("corpus", (Object)"macbeth").set("word", (Object)"bob");
    private static final TableRow row5 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"hi");
    static final TableRow[] ROWS_ARRAY = new TableRow[]{row1, row2, row3, row4, row5};
    private static final KV<String, String> tuple1 = KV.of((Object)"snuffleupaguses", (Object)"king_lear");
    private static final KV<String, String> tuple2 = KV.of((Object)"antidisestablishmentarianism", (Object)"macbeth");
    private static final KV<String, String> tuple3 = KV.of((Object)"antidisestablishmentarianism", (Object)"king_lear");
    private static final KV<String, String> combinedTuple1 = KV.of((Object)"antidisestablishmentarianism", (Object)"king_lear,macbeth");
    private static final KV<String, String> combinedTuple2 = KV.of((Object)"snuffleupaguses", (Object)"king_lear");
    static final KV<String, String>[] COMBINED_TUPLES_ARRAY = new KV[]{combinedTuple1, combinedTuple2};
    private static final TableRow resultRow1 = new TableRow().set("word", (Object)"snuffleupaguses").set("all_plays", (Object)"king_lear");
    private static final TableRow resultRow2 = new TableRow().set("word", (Object)"antidisestablishmentarianism").set("all_plays", (Object)"king_lear,macbeth");

    @Test
    public void testExtractLargeWordsFn() {
        DoFnTester extractLargeWordsFn = DoFnTester.of((DoFn)new CombinePerKeyExamples.ExtractLargeWordsFn());
        List results = extractLargeWordsFn.processBatch((Object[])ROWS_ARRAY);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple1));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple2));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple3));
    }

    @Test
    public void testFormatShakespeareOutputFn() {
        DoFnTester formatShakespeareOutputFn = DoFnTester.of((DoFn)new CombinePerKeyExamples.FormatShakespeareOutputFn());
        List results = formatShakespeareOutputFn.processBatch((Object[])COMBINED_TUPLES_ARRAY);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow1));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow2));
    }
}

