/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.examples.complete.AutoComplete;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutoCompleteTest
implements Serializable {
    private boolean recursive;

    public AutoCompleteTest(Boolean recursive) {
        this.recursive = recursive;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testRecursive() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testAutoComplete() {
        List<String> words = Arrays.asList("apple", "apple", "apricot", "banana", "blackberry", "blackberry", "blackberry", "blueberry", "blueberry", "cherry");
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)p.apply((PTransform)Create.of(words));
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)new AutoComplete.ComputeTopCompletions(2, this.recursive))).apply((PTransform)Filter.byPredicate((SerializableFunction)new SerializableFunction<KV<String, List<AutoComplete.CompletionCandidate>>, Boolean>(){

            public Boolean apply(KV<String, List<AutoComplete.CompletionCandidate>> element) {
                return ((String)element.getKey()).length() <= 2;
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", AutoCompleteTest.parseList("apple:2", "apricot:1")), KV.of((Object)"ap", AutoCompleteTest.parseList("apple:2", "apricot:1")), KV.of((Object)"b", AutoCompleteTest.parseList("blackberry:3", "blueberry:2")), KV.of((Object)"ba", AutoCompleteTest.parseList("banana:1")), KV.of((Object)"bl", AutoCompleteTest.parseList("blackberry:3", "blueberry:2")), KV.of((Object)"c", AutoCompleteTest.parseList("cherry:1")), KV.of((Object)"ch", AutoCompleteTest.parseList("cherry:1"))});
        p.run();
    }

    @Test
    public void testTinyAutoComplete() {
        List<String> words = Arrays.asList("x", "x", "x", "xy", "xy", "xyz");
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)p.apply((PTransform)Create.of(words));
        PCollection output = (PCollection)input.apply((PTransform)new AutoComplete.ComputeTopCompletions(2, this.recursive));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"x", AutoCompleteTest.parseList("x:3", "xy:2")), KV.of((Object)"xy", AutoCompleteTest.parseList("xy:2", "xyz:1")), KV.of((Object)"xyz", AutoCompleteTest.parseList("xyz:1"))});
        p.run();
    }

    @Test
    public void testWindowedAutoComplete() {
        List<TimestampedValue> words = Arrays.asList(TimestampedValue.of((Object)"xA", (Instant)new Instant(1L)), TimestampedValue.of((Object)"xA", (Instant)new Instant(1L)), TimestampedValue.of((Object)"xB", (Instant)new Instant(1L)), TimestampedValue.of((Object)"xB", (Instant)new Instant(2L)), TimestampedValue.of((Object)"xB", (Instant)new Instant(2L)));
        TestPipeline p = TestPipeline.create();
        PCollection input = (PCollection)((PCollection)p.apply((PTransform)Create.of(words))).apply(new ReifyTimestamps());
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)new Duration(2L))))).apply((PTransform)new AutoComplete.ComputeTopCompletions(2, this.recursive));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"x", AutoCompleteTest.parseList("xA:2", "xB:1")), KV.of((Object)"xA", AutoCompleteTest.parseList("xA:2")), KV.of((Object)"xB", AutoCompleteTest.parseList("xB:1")), KV.of((Object)"x", AutoCompleteTest.parseList("xB:3", "xA:2")), KV.of((Object)"xA", AutoCompleteTest.parseList("xA:2")), KV.of((Object)"xB", AutoCompleteTest.parseList("xB:3")), KV.of((Object)"x", AutoCompleteTest.parseList("xB:2")), KV.of((Object)"xB", AutoCompleteTest.parseList("xB:2"))});
        p.run();
    }

    private static List<AutoComplete.CompletionCandidate> parseList(String ... entries) {
        ArrayList<AutoComplete.CompletionCandidate> all = new ArrayList<AutoComplete.CompletionCandidate>();
        for (String s : entries) {
            String[] countValue = s.split(":");
            all.add(new AutoComplete.CompletionCandidate(countValue[0], (long)Integer.valueOf(countValue[1]).intValue()));
        }
        return all;
    }

    private static class ReifyTimestamps<T>
    extends PTransform<PCollection<TimestampedValue<T>>, PCollection<T>> {
        private ReifyTimestamps() {
        }

        public PCollection<T> apply(PCollection<TimestampedValue<T>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<TimestampedValue<T>, T>(){

                public void processElement(DoFn.ProcessContext c) {
                    c.outputWithTimestamp(((TimestampedValue)c.element()).getValue(), ((TimestampedValue)c.element()).getTimestamp());
                }
            }));
        }
    }
}

