/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.shiro;

import java.util.Properties;
import org.apache.batchee.container.services.security.DefaultSecurityService;
import org.apache.shiro.SecurityUtils;

public class ShiroSecurityService
extends DefaultSecurityService {
    private String instancePrefix;
    private String permissionPrefix;

    private boolean isAuthenticatedAndAuthorized(String permission) {
        return SecurityUtils.getSubject().isAuthenticated() && SecurityUtils.getSubject().isPermitted(permission);
    }

    public boolean isAuthorized(long instanceId) {
        return this.isAuthenticatedAndAuthorized(this.instancePrefix + instanceId);
    }

    public boolean isAuthorized(String perm) {
        return this.isAuthenticatedAndAuthorized(this.permissionPrefix + perm);
    }

    public String getLoggedUser() {
        if (SecurityUtils.getSubject().isAuthenticated()) {
            return SecurityUtils.getSubject().getPrincipal().toString();
        }
        return super.getLoggedUser();
    }

    public void init(Properties batchConfig) {
        super.init(batchConfig);
        this.permissionPrefix = batchConfig.getProperty("security.job.permission-prefix", "jbatch:");
        this.instancePrefix = this.permissionPrefix + batchConfig.getProperty("security.job.permission-prefix", "instance:");
    }
}

