/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.batch.api.BatchProperty;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.batchee.doc.api.Documentation;

public abstract class JdbcConnectionConfiguration {
    @Inject
    @BatchProperty
    @Documentation(value="The JNDI name of the datasource")
    private String jndi;
    @Inject
    @BatchProperty
    @Documentation(value="The datasource driver to use if jndi is null")
    protected String driver;
    @Inject
    @BatchProperty
    @Documentation(value="The datasource url to use if jndi is null")
    protected String url;
    @Inject
    @BatchProperty
    @Documentation(value="The datasource user to use if jndi is null")
    protected String user;
    @Inject
    @BatchProperty
    @Documentation(value="The datasource password to use if jndi is null")
    protected String password;

    protected Connection connection() throws Exception {
        if (this.jndi != null) {
            return ((DataSource)DataSource.class.cast(new InitialContext().lookup(this.jndi))).getConnection();
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
        return DriverManager.getConnection(this.url, this.user, this.password);
    }
}

