/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.tools.services.thread;

import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.transaction.UserTransaction;

@Singleton
@Lock(value=LockType.READ)
@TransactionManagement(value=TransactionManagementType.BEAN)
public class ThreadExecutorEjb {
    @Resource
    private UserTransaction ut;
    private static ThreadLocal<UserTransaction> userTransactions = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    public void executeTask(Runnable work, Object config) {
        try {
            userTransactions.set(this.ut);
            work.run();
        }
        finally {
            userTransactions.remove();
        }
    }

    public static UserTransaction getUserTransaction() {
        return userTransactions.get();
    }
}

