/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.batch.operations.JobOperator;
import javax.batch.operations.NoSuchJobException;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.api.Command;

@Command(name="running", description="list running batches")
public class Running
extends JobOperatorCommand {
    @Override
    public void doRun() {
        JobOperator operator = this.operator();
        Set names = operator.getJobNames();
        if (names == null || names.isEmpty()) {
            this.info("No job started");
        } else {
            List running;
            HashMap<String, List> runnings = new HashMap<String, List>();
            for (String string : names) {
                try {
                    running = operator.getRunningExecutions(string);
                    if (running == null) continue;
                    runnings.put(string, running);
                }
                catch (NoSuchJobException nsje) {}
            }
            if (runnings.isEmpty()) {
                this.info("No job started");
            } else {
                for (Map.Entry entry : runnings.entrySet()) {
                    running = (List)entry.getValue();
                    this.info((String)entry.getKey() + " -> " + Arrays.toString((Object[])running.toArray(new Long[running.size()])));
                }
            }
        }
    }
}

