/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.jul;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private static final String ST_SEP = System.lineSeparator() + " ";
    private static final String TIME_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private static final ThreadLocal<DateFormat> LOCAL_DATE_CACHE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(OneLineFormatter.TIME_FORMAT);
        }
    };

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.addTimestamp(sb, record.getMillis());
        sb.append(' ');
        sb.append(record.getLevel());
        sb.append(' ');
        sb.append('[');
        sb.append(Thread.currentThread().getName());
        sb.append(']');
        sb.append(' ');
        sb.append(record.getSourceClassName());
        sb.append('.');
        sb.append(record.getSourceMethodName());
        sb.append(' ');
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append(ST_SEP);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.getBuffer());
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    protected void addTimestamp(StringBuilder buf, long timestamp) {
        buf.append(LOCAL_DATE_CACHE.get().format(new Date(timestamp)));
        long frac = timestamp % 1000L;
        buf.append('.');
        if (frac < 100L) {
            if (frac < 10L) {
                buf.append('0');
                buf.append('0');
            } else {
                buf.append('0');
            }
        }
        buf.append(frac);
    }
}

