/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.bootstrap;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.batchee.cli.classloader.ChildFirstURLClassLoader;

public class Bootstrap {
    public static void main(String[] args) throws Exception {
        String batcheeHome = System.getProperty("batchee.home");
        if (batcheeHome == null) {
            throw new IllegalArgumentException("batchee.home system property not set");
        }
        File home = new File(batcheeHome);
        if (!home.isDirectory()) {
            throw new IllegalArgumentException("batchee.home doesn't exist '" + batcheeHome + "'");
        }
        File libsDir = new File(batcheeHome, "lib");
        if (!libsDir.isDirectory()) {
            throw new IllegalArgumentException("lib directory doesn't exist '" + libsDir.getAbsolutePath() + "'");
        }
        File[] libs = libsDir.listFiles();
        if (libs == null) {
            throw new IllegalArgumentException("no lib found");
        }
        ArrayList<URL> urls = new ArrayList<URL>(libs.length);
        for (File f : libs) {
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
        ChildFirstURLClassLoader loader = new ChildFirstURLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> cli = loader.loadClass("org.apache.batchee.cli.BatchEECLI");
        cli.getMethod("main", String[].class).invoke(null, new Object[]{args});
    }

    private Bootstrap() {
    }
}

