/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public abstract class BaseContext<K>
implements Context {
    private final ConcurrentMap<K, ConcurrentMap<Contextual<?>, Instance<?>>> storages = new ConcurrentHashMap();

    protected abstract K[] currentKeys();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.checkActive();
        ConcurrentMap<Contextual<?>, Instance<?>> storage = this.getOrCreateCurrentStorage();
        Instance instance = (Instance)storage.get(component);
        if (instance == null) {
            BaseContext baseContext = this;
            synchronized (baseContext) {
                instance = (Instance)storage.get(component);
                if (instance == null) {
                    Object value = component.create(creationalContext);
                    instance = new Instance(value, creationalContext);
                    storage.putIfAbsent(component, instance);
                }
            }
        }
        return (T)instance.value;
    }

    public <T> T get(Contextual<T> component) {
        this.checkActive();
        for (K key : this.currentKeys()) {
            ConcurrentMap storage = (ConcurrentMap)this.storages.get(key);
            if (storage == null) continue;
            Instance instance = (Instance)storage.get(component);
            if (instance == null) {
                return null;
            }
            return (T)instance.value;
        }
        return null;
    }

    public boolean isActive() {
        K[] ks = this.currentKeys();
        return ks != null && ks.length != 0;
    }

    public void endContext() {
        ConcurrentMap storage = (ConcurrentMap)this.storages.remove(this.lastKey());
        if (storage == null) {
            return;
        }
        for (Map.Entry entry : storage.entrySet()) {
            Instance instance = (Instance)entry.getValue();
            ((Contextual)Contextual.class.cast(entry.getKey())).destroy(instance.value, instance.context);
        }
        storage.clear();
    }

    private K lastKey() {
        K[] keys = this.currentKeys();
        if (keys == null || keys.length == 0) {
            return null;
        }
        return keys[keys.length - 1];
    }

    private void checkActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    private ConcurrentMap<Contextual<?>, Instance<?>> getOrCreateCurrentStorage() {
        ConcurrentMap existing;
        K key = this.lastKey();
        ConcurrentMap storage = (ConcurrentHashMap)this.storages.get(key);
        if (storage == null && (existing = (ConcurrentMap)this.storages.putIfAbsent(key, storage = new ConcurrentHashMap())) != null) {
            storage = existing;
        }
        return storage;
    }

    private static class Instance<T> {
        private final T value;
        private final CreationalContext<T> context;

        private Instance(T value, CreationalContext<T> context) {
            this.value = value;
            this.context = context;
        }
    }
}

