/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Loader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RampartUtil {
    private static final String CRYPTO_PROVIDER = "org.apache.ws.security.crypto.provider";
    private static Log log = LogFactory.getLog((Class)RampartUtil.class);

    public static CallbackHandler getPasswordCB(RampartMessageData rmd) throws RampartException {
        MessageContext msgContext = rmd.getMsgContext();
        RampartPolicyData rpd = rmd.getPolicyData();
        return RampartUtil.getPasswordCB(msgContext, rpd);
    }

    public static CallbackHandler getPasswordCB(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        CallbackHandler cbHandler;
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getPwCbClass() != null) {
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getPwCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            log.debug((Object)("loading class : " + cbHandlerClass));
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadPWCBClass", new String[]{cbHandlerClass}, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new RampartException("cannotCreatePWCBInstance", new String[]{cbHandlerClass}, e);
            }
        }
        cbHandler = (CallbackHandler)msgContext.getProperty("passwordCallbackRef");
        if (cbHandler == null) {
            Parameter param = msgContext.getParameter("passwordCallbackRef");
            cbHandler = (CallbackHandler)param.getValue();
        }
        return cbHandler;
    }

    public static WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws RampartException {
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new RampartException("pwcbFailed", e);
        }
        return pwCb;
    }

    public static Crypto getEncryptionCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        log.debug((Object)"Loading encryption crypto");
        if (config != null && config.getEncrCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getEncrCryptoConfig();
            String provider = cryptoConfig.getProvider();
            log.debug((Object)("Usig provider: " + provider));
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            return CryptoFactory.getInstance((Properties)prop, (ClassLoader)loader);
        }
        log.debug((Object)"Trying the signature crypto info");
        if (config != null && config.getSigCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getSigCryptoConfig();
            String provider = cryptoConfig.getProvider();
            log.debug((Object)("Usig provider: " + provider));
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            return CryptoFactory.getInstance((Properties)prop, (ClassLoader)loader);
        }
        return null;
    }

    public static Crypto getSignatureCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        log.debug((Object)"Loading Signature crypto");
        if (config != null && config.getSigCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getSigCryptoConfig();
            String provider = cryptoConfig.getProvider();
            log.debug((Object)("Usig provider: " + provider));
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            return CryptoFactory.getInstance((Properties)prop, (ClassLoader)loader);
        }
        return null;
    }

    public static int getKeyIdentifier(X509Token token) throws RampartException {
        if (token.isRequireIssuerSerialReference()) {
            return 2;
        }
        if (token.isRequireThumbprintReference()) {
            return 8;
        }
        if (token.isRequireEmbeddedTokenReference()) {
            return 1;
        }
        throw new RampartException("unknownKeyRefSpeficier");
    }

    public static String processIssuerAddress(OMElement issuerAddress) throws RampartException {
        if (issuerAddress != null && issuerAddress.getText() != null && !"".equals(issuerAddress.getText())) {
            return issuerAddress.getText().trim();
        }
        throw new RampartException("invalidIssuerAddress", new String[]{issuerAddress.toString()});
    }

    public static OMElement createRSTTempalteForSCT(int conversationVersion, int wstVersion) throws RampartException {
        try {
            log.debug((Object)"Creating RSTTemplate for an SCT request");
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace wspNs = fac.createOMNamespace("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "wsp");
            OMElement rstTempl = fac.createOMElement(Constants.REQUEST_SECURITY_TOKEN_TEMPLATE.getLocalPart(), wspNs);
            OMElement tokenTypeElem = TrustUtil.createTokenTypeElement((int)wstVersion, (OMElement)rstTempl);
            String tokenType = ConversationConstants.getWSCNs((int)conversationVersion) + "/sct";
            tokenTypeElem.setText(tokenType);
            return rstTempl;
        }
        catch (TrustException e) {
            throw new RampartException("errorCreatingRSTTemplateForSCT", e);
        }
        catch (ConversationException e) {
            throw new RampartException("errorCreatingRSTTemplateForSCT", e);
        }
    }

    public static int getTimeToLive(RampartMessageData messageData) {
        RampartConfig rampartConfig = messageData.getPolicyData().getRampartConfig();
        if (rampartConfig != null) {
            String ttl = rampartConfig.getTimestampTTL();
            int ttl_i = 0;
            if (ttl != null) {
                try {
                    ttl_i = Integer.parseInt(ttl);
                }
                catch (NumberFormatException e) {
                    ttl_i = messageData.getTimeToLive();
                }
            }
            if (ttl_i <= 0) {
                ttl_i = messageData.getTimeToLive();
            }
            return ttl_i;
        }
        return 300000;
    }

    public static String getSecConvToken(RampartMessageData rmd, SecureConversationToken secConvTok) throws TrustException, RampartException {
        String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/SCT");
        OMElement issuerEpr = secConvTok.getIssuerEpr();
        String issuerEprAddress = rmd.getMsgContext().getTo().getAddress();
        if (issuerEpr != null) {
            issuerEprAddress = RampartUtil.processIssuerAddress(issuerEpr);
        }
        int conversationVersion = rmd.getSecConvVersion();
        OMElement rstTemplate = RampartUtil.createRSTTempalteForSCT(conversationVersion, rmd.getWstVersion());
        Policy stsPolicy = null;
        Policy bsPol = secConvTok.getBootstrapPolicy();
        if (bsPol != null) {
            log.debug((Object)"BootstrapPolicy found");
            bsPol.addAssertion((Assertion)rmd.getPolicyData().getRampartConfig());
            stsPolicy = bsPol;
        } else {
            log.debug((Object)"No bootstrap policy, using issuer policy");
            stsPolicy = rmd.getPolicyData().getIssuerPolicy();
        }
        String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
        log.debug((Object)("SecureConversationToken obtained: id=" + id));
        return id;
    }

    public static String getIssuedToken(RampartMessageData rmd, IssuedToken issuedToken) throws RampartException {
        try {
            String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/Issue");
            String issuerEprAddress = RampartUtil.processIssuerAddress(issuedToken.getIssuerEpr());
            OMElement rstTemplate = issuedToken.getRstTemplate();
            Policy stsPolicy = rmd.getPolicyData().getIssuerPolicy();
            String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
            log.debug((Object)("Issued token obtained: id=" + id));
            return id;
        }
        catch (TrustException e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getToken(RampartMessageData rmd, OMElement rstTemplate, String issuerEpr, String action, Policy issuerPolicy) throws RampartException {
        try {
            Axis2Util.useDOOM(false);
            STSClient client = new STSClient(rmd.getMsgContext().getConfigurationContext());
            client.setAction(action);
            client.setRstTemplate(rstTemplate);
            Crypto crypto = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getMsgContext().getAxisService().getClassLoader());
            CallbackHandler cbh = RampartUtil.getPasswordCB(rmd);
            client.setCryptoInfo(crypto, cbh);
            Policy servicePolicy = rmd.getServicePolicy();
            String servceEprAddress = rmd.getMsgContext().getOptions().getTo().getAddress();
            Token rst = client.requestSecurityToken(servicePolicy, issuerEpr, issuerPolicy, servceEprAddress);
            rst.setState(1);
            rmd.getTokenStorage().add(rst);
            Axis2Util.useDOOM(true);
            return rst.getId();
        }
        catch (Exception e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getSoapBodyId(SOAPEnvelope env) {
        return RampartUtil.addWsuIdToElement((OMElement)env.getBody());
    }

    public static String addWsuIdToElement(OMElement elem) {
        String id;
        OMAttribute idAttr = elem.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        if (idAttr != null) {
            id = idAttr.getAttributeValue();
        } else {
            OMNamespace ns = elem.getOMFactory().createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            id = "Id-" + elem.hashCode();
            idAttr = elem.getOMFactory().createOMAttribute("Id", ns, id);
            elem.addAttribute(idAttr);
        }
        return id;
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, OMElement elem) {
        return RampartUtil.appendChildToSecHeader(rmd, (Element)elem);
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, Element elem) {
        Element secHeaderElem = rmd.getSecHeader().getSecurityHeader();
        Node node = secHeaderElem.getOwnerDocument().importNode(elem, true);
        return (Element)secHeaderElem.appendChild(node);
    }

    public static Element insertSiblingAfter(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static Element insertSiblingBefore(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static Vector getEncryptedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        Vector parts = rpd.getEncryptedParts();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        if (rpd.isEncryptBody()) {
            parts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)envelope.getBody()), "Content"));
        }
        return parts;
    }

    public static Vector getSignedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        Vector parts = rpd.getSignedParts();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        if (rpd.isEntireHeadersAndBodySignatures()) {
            Iterator childElems = envelope.getHeader().getChildElements();
            while (childElems.hasNext()) {
                OMElement element = (OMElement)childElems.next();
                if (element.getQName().equals(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security")) || element.getQName().equals(new QName("http://docs.oasis-open.org/wss/2005/xx/oasis-2005xx-wss-wssecurity-secext-1.1.xsd", "Security"))) continue;
                parts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement(element)));
            }
            parts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)envelope.getBody())));
        } else if (rpd.isEncryptBody()) {
            parts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)envelope.getBody())));
        }
        return parts;
    }

    public static KeyGenerator getEncryptionKeyGenerator(String symEncrAlgo) throws WSSecurityException {
        KeyGenerator keyGen;
        block6: {
            try {
                keyGen = KeyGenerator.getInstance("AES");
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGen = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGen.init(128);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGen.init(192);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGen.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(2, null, null, (Throwable)e);
            }
        }
        return keyGen;
    }

    public static String getContextIdentifierKey(MessageContext msgContext) {
        return msgContext.getAxisService().getName();
    }

    public static Hashtable getContextMap(MessageContext msgContext) {
        Hashtable map = msgContext.getConfigurationContext().getProperty("contextMap");
        if (map == null) {
            map = new Hashtable();
            msgContext.getConfigurationContext().setProperty("contextMap", map);
        }
        return map;
    }

    public static boolean isTokenValid(RampartMessageData rmd, String id) throws RampartException {
        try {
            Token token = rmd.getTokenStorage().getToken(id);
            return token != null && token.getState() == 1;
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setEncryptionUser(RampartMessageData rmd, WSSecEncryptedKey encrKeyBuilder) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        String encrUser = rpd.getRampartConfig().getEncryptionUser();
        if (encrUser == null || "".equals(encrUser)) {
            throw new RampartException("missingEncryptionUser");
        }
        if (encrUser.equals("useReqSigCert")) {
            Object resultsObj = rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            encrKeyBuilder.setUseThisCert(RampartUtil.getReqSigCert((Vector)resultsObj));
            return;
        } else {
            encrKeyBuilder.setUserInfo(encrUser);
        }
    }

    private static X509Certificate getReqSigCert(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                return wser.getCertificate();
            }
        }
        return null;
    }

    public static String getRequestEncryptedKeyId(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 4 || wser.getEncryptedKeyId() == null) continue;
                return wser.getEncryptedKeyId();
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 4 || wser.getDecryptedKey() == null) continue;
                return wser.getDecryptedKey();
            }
        }
        return null;
    }
}

