/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.ws.security.WSSecurityException;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class MessageOptimizer {
    public static void optimize(SOAPEnvelope env, String optimizeParts) throws WSSecurityException {
        String separater = "<>";
        StringTokenizer tokenizer = new StringTokenizer(optimizeParts, separater);
        while (tokenizer.hasMoreTokens()) {
            String xpathExpr = tokenizer.nextToken();
            List list = MessageOptimizer.findElements((OMElement)env, xpathExpr);
            Iterator cipherValueElements = list.iterator();
            while (cipherValueElements.hasNext()) {
                OMElement element = (OMElement)cipherValueElements.next();
                OMText text = (OMText)element.getFirstOMChild();
                System.out.println(text.getText().length());
                text.setOptimize(true);
            }
        }
    }

    private static List findElements(OMElement elem, String expression) throws WSSecurityException {
        try {
            AXIOMXPath xp = new AXIOMXPath(expression);
            SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
            nsCtx.addNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
            nsCtx.addNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
            nsCtx.addNamespace("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            nsCtx.addNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            xp.setNamespaceContext((NamespaceContext)nsCtx);
            return xp.selectNodes((Object)elem);
        }
        catch (JaxenException e) {
            throw new WSSecurityException(e.getMessage(), (Throwable)e);
        }
    }
}

