/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.ws.security.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Axis2Util {
    private static ThreadLocal doomTacker = new ThreadLocal();

    public static boolean isUseDOOM() {
        Object value = doomTacker.get();
        return value != null;
    }

    public static void useDOOM(boolean isDOOMRequired) {
    }

    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env, boolean disableDoom) throws WSSecurityException {
        try {
            if (env instanceof Element) {
                return ((Element)env).getOwnerDocument();
            }
            if (!disableDoom) {
                SOAPFactory factory;
                env.build();
                OMElement firstElement = env.getBody().getFirstElement();
                if (firstElement != null) {
                    firstElement.build();
                }
                String nsURI = null;
                if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
                    factory = DOOMAbstractFactory.getSOAP11Factory();
                } else {
                    nsURI = "http://www.w3.org/2003/05/soap-envelope";
                    factory = DOOMAbstractFactory.getSOAP12Factory();
                }
                StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
                SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                ((OMNode)envelope.getParent()).build();
                Element envElem = (Element)envelope;
                return envElem.getOwnerDocument();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            env.build();
            env.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(bais);
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in converting SOAP Envelope to Document", (Throwable)e);
        }
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOOMDocument(Document doc) throws WSSecurityException {
        try {
            XMLStreamReader reader = ((OMElement)doc.getDocumentElement()).getXMLStreamReader();
            StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(reader, null);
            SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
            envelope.build();
            return envelope;
        }
        catch (FactoryConfigurationError e) {
            throw new WSSecurityException(e.getMessage());
        }
    }

    public static String getKey(String originalKey, boolean inHandler, int repetition) {
        if (!(repetition <= 0 || inHandler || originalKey.equals("OutflowSecurity") || originalKey.equals("senderRepeatCount"))) {
            return originalKey + repetition;
        }
        return originalKey;
    }

    public static OMElement toDOOM(OMFactory factory, OMElement element) {
        StAXOMBuilder builder = new StAXOMBuilder(factory, element.getXMLStreamReader());
        OMElement elem = builder.getDocumentElement();
        elem.build();
        return elem;
    }
}

