/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy;

import java.util.Iterator;
import java.util.List;
import org.apache.neethi.Assertion;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AsymmetricBinding;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.EncryptionToken;
import org.apache.ws.secpolicy.model.Header;
import org.apache.ws.secpolicy.model.InitiatorToken;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.RecipientToken;
import org.apache.ws.secpolicy.model.SignatureToken;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;
import org.apache.ws.secpolicy.model.SymmetricBinding;
import org.apache.ws.secpolicy.model.TransportBinding;
import org.apache.ws.secpolicy.model.Trust10;
import org.apache.ws.secpolicy.model.Wss10;
import org.apache.ws.secpolicy.model.Wss11;

public class RampartPolicyBuilder {
    public static RampartPolicyData build(List topLevelAssertions) throws WSSPolicyException {
        RampartPolicyData rpd = new RampartPolicyData();
        Iterator iter = topLevelAssertions.iterator();
        while (iter.hasNext()) {
            Assertion assertion = (Assertion)iter.next();
            if (assertion instanceof Binding) {
                if (assertion instanceof SymmetricBinding) {
                    RampartPolicyBuilder.processSymmetricPolicyBinding((SymmetricBinding)assertion, rpd);
                    continue;
                }
                if (assertion instanceof AsymmetricBinding) {
                    RampartPolicyBuilder.processAsymmetricPolicyBinding((AsymmetricBinding)assertion, rpd);
                    continue;
                }
                RampartPolicyBuilder.processTransportBinding((TransportBinding)assertion, rpd);
                continue;
            }
            if (assertion instanceof Wss11) {
                RampartPolicyBuilder.processWSS11((Wss11)assertion, rpd);
                continue;
            }
            if (assertion instanceof Wss10) {
                RampartPolicyBuilder.processWSS10((Wss10)assertion, rpd);
                continue;
            }
            if (assertion instanceof SignedEncryptedElements) {
                RampartPolicyBuilder.processSignedEncryptedElements((SignedEncryptedElements)assertion, rpd);
                continue;
            }
            if (assertion instanceof SignedEncryptedParts) {
                RampartPolicyBuilder.processSignedEncryptedParts((SignedEncryptedParts)assertion, rpd);
                continue;
            }
            if (assertion instanceof SupportingToken) {
                RampartPolicyBuilder.processSupportingTokens((SupportingToken)assertion, rpd);
                continue;
            }
            if (assertion instanceof Trust10) {
                RampartPolicyBuilder.processTrust10((Trust10)assertion, rpd);
                continue;
            }
            if (assertion instanceof RampartConfig) {
                RampartPolicyBuilder.processRampartConfig((RampartConfig)assertion, rpd);
                continue;
            }
            System.out.println("Unknown top level PED found: " + assertion.getClass().getName());
        }
        return rpd;
    }

    private static void processTransportBinding(TransportBinding binding, RampartPolicyData rpd) {
        RampartPolicyBuilder.binding((Binding)binding, rpd);
        rpd.setTransportBinding(true);
    }

    private static void processTrust10(Trust10 trust10, RampartPolicyData rpd) {
        rpd.setTrust10(trust10);
    }

    private static void processRampartConfig(RampartConfig config, RampartPolicyData rpd) {
        rpd.setRampartConfig(config);
    }

    private static void processSymmetricPolicyBinding(SymmetricBinding symmBinding, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setSymmetricBinding(true);
        RampartPolicyBuilder.binding((Binding)symmBinding, rpd);
        RampartPolicyBuilder.symmAsymmBinding((SymmetricAsymmetricBindingBase)symmBinding, rpd);
        RampartPolicyBuilder.symmetricBinding(symmBinding, rpd);
    }

    private static void processWSS10(Wss10 wss10, RampartPolicyData rpd) {
        rpd.setWss10(wss10);
    }

    private static void processAsymmetricPolicyBinding(AsymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setSymmetricBinding(false);
        RampartPolicyBuilder.binding((Binding)binding, rpd);
        RampartPolicyBuilder.symmAsymmBinding((SymmetricAsymmetricBindingBase)binding, rpd);
        RampartPolicyBuilder.asymmetricBinding(binding, rpd);
    }

    private static void processWSS11(Wss11 wss11, RampartPolicyData rpd) {
        rpd.setSignatureConfirmation(wss11.isRequireSignatureConfirmation());
        rpd.setWss11(wss11);
    }

    private static void processSignedEncryptedElements(SignedEncryptedElements see, RampartPolicyData rpd) {
        Iterator it = see.getXPathExpressions().iterator();
        if (see.isSignedElemets()) {
            while (it.hasNext()) {
                rpd.setSignedElements((String)it.next());
            }
        } else {
            while (it.hasNext()) {
                rpd.setEncryptedElements((String)it.next());
            }
        }
    }

    private static void processSignedEncryptedParts(SignedEncryptedParts sep, RampartPolicyData rpd) {
        Iterator it = sep.getHeaders().iterator();
        if (sep.isSignedParts()) {
            rpd.setSignBody(sep.isBody());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                rpd.setSignedParts(header.getNamespace(), header.getName());
            }
        } else {
            rpd.setEncryptBody(sep.isBody());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                rpd.setEncryptedParts(header.getNamespace(), header.getName());
            }
        }
    }

    private static void binding(Binding binding, RampartPolicyData rpd) {
        rpd.setLayout(binding.getLayout().getValue());
        rpd.setIncludeTimestamp(binding.isIncludeTimestamp());
        rpd.setAlgorithmSuite(binding.getAlgorithmSuite());
    }

    private static void symmAsymmBinding(SymmetricAsymmetricBindingBase binding, RampartPolicyData rpd) {
        rpd.setEntireHeadersAndBodySignatures(binding.isEntireHeadersAndBodySignatures());
        rpd.setProtectionOrder(binding.getProtectionOrder());
        rpd.setSignatureProtection(binding.isSignatureProtection());
        rpd.setTokenProtection(binding.isTokenProtection());
        rpd.setAlgorithmSuite(binding.getAlgorithmSuite());
    }

    private static void symmetricBinding(SymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        ProtectionToken token = binding.getProtectionToken();
        if (token != null) {
            rpd.setProtectionToken(token.getProtectionToken());
        } else {
            token = binding.getEncryptionToken();
            SignatureToken token1 = binding.getSignatureToken();
            if (token != null || token1 == null) {
                // empty if block
            }
            rpd.setEncryptionToken(((EncryptionToken)token).getEncryptionToken());
            rpd.setSignatureToken(((SignatureToken)token).getSignatureToken());
        }
    }

    private static void asymmetricBinding(AsymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        RecipientToken tokWrapper = binding.getRecipientToken();
        InitiatorToken tokWrapper1 = binding.getInitiatorToken();
        if (tokWrapper != null || tokWrapper1 == null) {
            // empty if block
        }
        rpd.setRecipientToken(tokWrapper.getReceipientToken());
        rpd.setInitiatorToken(tokWrapper1.getInitiatorToken());
    }

    private static void processSupportingTokens(SupportingToken token, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setSupportingTokens(token);
    }
}

