/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.conversation.ConversationConfiguration;
import org.apache.rampart.conversation.STSRequester;
import org.apache.rampart.conversation.Util;
import org.apache.rampart.handler.WSDoAllHandler;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.HandlerParameterDecoder;
import org.apache.rampart.util.MessageOptimizer;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDoAllSender
extends WSDoAllHandler {
    private static final Log log = LogFactory.getLog((Class)WSDoAllSender.class);

    public WSDoAllSender() {
        this.inHandler = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(MessageContext msgContext) throws AxisFault {
        block8: {
            String disableDoomValue = (String)msgContext.getProperty("useDoom");
            boolean disableDoom = disableDoomValue != null && "true".equalsIgnoreCase(disableDoomValue);
            RequestData reqData = new RequestData();
            try {
                try {
                    Parameter param = ConversationConfiguration.getParameter(msgContext);
                    if (param == null || "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT".equals(msgContext.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT".equals(msgContext.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/Issue".equals(msgContext.getWSAAction())) {
                        this.processBasic(msgContext, disableDoom, reqData);
                    } else {
                        this.processSecConv(msgContext);
                    }
                }
                catch (Exception e) {
                    throw new AxisFault(e.getMessage(), (Throwable)e);
                }
                Object var7_7 = null;
                if (reqData == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (reqData != null) {
                    reqData.clear();
                    reqData = null;
                }
                throw throwable;
            }
            reqData.clear();
            return;
        }
    }

    private void processSecConv(MessageContext msgContext) throws Exception {
        ConversationConfiguration config = ConversationConfiguration.load(msgContext, true);
        if (config != null) {
            msgContext.setEnvelope((SOAPEnvelope)config.getDocument().getDocumentElement());
        }
        if (!config.getMsgCtx().isServerSide() && config.getContextIdentifier() == null && !config.getMsgCtx().isServerSide()) {
            String sts = config.getStsEPRAddress();
            if (sts != null) {
                Axis2Util.useDOOM(false);
                STSRequester.issueRequest(config);
                Axis2Util.useDOOM(true);
            } else {
                this.createRSTR(config);
            }
        }
        this.constructMessage(config);
    }

    private void processBasic(MessageContext msgContext, boolean disableDoom, RequestData reqData) throws WSSecurityException, AxisFault {
        Integer repeat;
        String username;
        MessageContext inMsgCtx;
        OperationContext opCtx;
        boolean doDebug = log.isDebugEnabled();
        try {
            HandlerParameterDecoder.processParameters(msgContext, false);
        }
        catch (Exception e) {
            throw new AxisFault("Configureation error", (Throwable)e);
        }
        if (doDebug) {
            log.debug((Object)"WSDoAllSender: enter invoke()");
        }
        if ((opCtx = msgContext.getOperationContext()) != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
            msgContext.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
        }
        reqData.setNoSerialization(false);
        reqData.setMsgContext((Object)msgContext);
        if (this.getOption("OutflowSecurity") == null && this.getProperty(msgContext, "OutflowSecurity") == null) {
            if (msgContext.isServerSide() && this.getOption("OutflowSecurity-server") == null && this.getProperty(msgContext, "OutflowSecurity-server") == null) {
                return;
            }
            if (this.getOption("OutflowSecurity-client") == null && this.getProperty(msgContext, "OutflowSecurity-client") == null) {
                return;
            }
        }
        Vector actions = new Vector();
        String action = null;
        action = (String)this.getOption("items");
        if (action == null) {
            action = (String)this.getProperty(msgContext, "items");
        }
        if (action == null) {
            throw new AxisFault("WSDoAllReceiver: No action items defined");
        }
        int doAction = WSSecurityUtil.decodeAction((String)action, actions);
        if (doAction == 0) {
            return;
        }
        reqData.setUsername((String)this.getOption("user"));
        if ((reqData.getUsername() == null || reqData.getUsername().length() == 0) && (username = (String)this.getProperty(reqData.getMsgContext(), "user")) != null) {
            reqData.setUsername(username);
        }
        if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().length() == 0)) {
            throw new AxisFault("WSDoAllSender: Empty username for specified action");
        }
        Document doc = null;
        doc = (Document)((MessageContext)reqData.getMsgContext()).getProperty("SND_SECURITY");
        if (doc == null) {
            try {
                doc = Axis2Util.getDocumentFromSOAPEnvelope(msgContext.getEnvelope(), disableDoom);
            }
            catch (WSSecurityException wssEx) {
                throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
            }
        }
        this.doSenderAction(doAction, doc, reqData, actions, !msgContext.isServerSide());
        if (reqData.isNoSerialization()) {
            ((MessageContext)reqData.getMsgContext()).setProperty("SND_SECURITY", (Object)doc);
        } else {
            msgContext.setEnvelope((SOAPEnvelope)doc.getDocumentElement());
            ((MessageContext)reqData.getMsgContext()).setProperty("SND_SECURITY", null);
        }
        String optimizeParts = (String)this.getOption("optimizeParts");
        if (optimizeParts == null) {
            optimizeParts = (String)this.getProperty(reqData.getMsgContext(), "optimizeParts");
        }
        if (optimizeParts != null) {
            MessageOptimizer.optimize(msgContext.getEnvelope(), optimizeParts);
        }
        if ((repeat = (Integer)this.getOption("senderRepeatCount")) == null) {
            repeat = (Integer)this.getProperty(reqData.getMsgContext(), "senderRepeatCount");
        }
        int repeatCount = repeat;
        int repetition = this.getCurrentRepetition(msgContext);
        if (repeatCount > 0 && repetition < repeatCount) {
            reqData.clear();
            reqData = null;
            msgContext.setProperty("currentRepetition", (Object)new Integer(++repetition));
            this.invoke(msgContext);
        }
        if (doDebug) {
            log.debug((Object)"WSDoAllSender: exit invoke()");
        }
    }

    private void createRSTR(ConversationConfiguration config) throws Exception {
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        Crypto crypto = Util.getCryptoInstace(config);
        String encryptionUser = config.getEncryptionUser();
        if (encryptionUser == null) {
            throw new RampartException("missingEncryptionUser");
        }
        X509Certificate cert = crypto.getCertificates(encryptionUser)[0];
        encrKeyBuilder.setKeyIdentifierType(8);
        try {
            encrKeyBuilder.setUseThisCert(cert);
            encrKeyBuilder.prepare(config.getDocument(), crypto);
        }
        catch (WSSecurityException e) {
            throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", (Object[])new String[]{cert.getSubjectDN().getName()}, (Throwable)e);
        }
        SecurityContextToken sct = new SecurityContextToken(config.getDocument());
        Util.resgisterContext(sct.getIdentifier(), config);
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + 300000L);
        Token token = new Token(sct.getIdentifier(), (OMElement)sct.getElement(), creationTime, expirationTime);
        token.setSecret(encrKeyBuilder.getEphemeralKey());
        config.getTokenStore().add(token);
        SOAPEnvelope env = config.getMsgCtx().getEnvelope();
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = ((SOAPFactory)env.getOMFactory()).createSOAPHeader(env);
        }
        OMElement rstrElem = TrustUtil.createRequestSecurityTokenResponseElement((int)config.getWstVersion(), (OMElement)header);
        OMElement rstElem = TrustUtil.createRequestedSecurityTokenElement((int)config.getWstVersion(), (OMElement)rstrElem);
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement((int)config.getWstVersion(), (OMElement)rstrElem, (String)zulu.format(creationTime), (String)zulu.format(expirationTime));
        rstElem.addChild((OMNode)((OMElement)sct.getElement()));
        TrustUtil.createRequestedAttachedRef((int)config.getWstVersion(), (OMElement)rstrElem, (String)("#" + sct.getID()), (String)"http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        TrustUtil.createRequestedUnattachedRef((int)config.getWstVersion(), (OMElement)rstrElem, (String)sct.getIdentifier(), (String)"http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        Element encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
        Element bstElem = encrKeyBuilder.getBinarySecurityTokenElement();
        OMElement reqProofTok = TrustUtil.createRequestedProofTokenElement((int)config.getWstVersion(), (OMElement)rstrElem);
        if (bstElem != null) {
            reqProofTok.addChild((OMNode)((OMElement)bstElem));
        }
        reqProofTok.addChild((OMNode)((OMElement)encryptedKeyElem));
    }

    private void constructMessage(ConversationConfiguration config) throws Exception {
        Document doc = config.getDocument();
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Token tempToken = config.getTokenStore().getToken(config.getContextIdentifier());
        byte[] tempSecret = tempToken.getSecret();
        SecurityContextToken sct = new SecurityContextToken((Element)doc.importNode((Element)tempToken.getToken(), true));
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        OMElement attachedReference = tempToken.getAttachedReference();
        if (attachedReference != null) {
            encrBuilder.setExternalKey(tempSecret, (Element)doc.importNode((Element)attachedReference, true));
        } else {
            String tokenId = sct.getID();
            encrBuilder.setExternalKey(tempSecret, tokenId);
        }
        encrBuilder.build(doc, secHeader);
        WSSecurityUtil.prependChildElement((Document)doc, (Element)secHeader.getSecurityHeader(), (Element)sct.getElement(), (boolean)false);
    }
}

