/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.rampart.RampartEngine;
import org.apache.rampart.RampartException;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;

public class RampartReceiver
implements Handler {
    private static HandlerDescription EMPTY_HANDLER_METADATA = new HandlerDescription("deafult Handler");
    private HandlerDescription handlerDesc = EMPTY_HANDLER_METADATA;

    public void cleanup() {
    }

    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Vector wsResult;
        if (!msgContext.isEngaged(new QName("rampart"))) {
            return Handler.InvocationResponse.CONTINUE;
        }
        RampartEngine engine = new RampartEngine();
        try {
            wsResult = engine.process(msgContext);
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            throw new AxisFault((Throwable)e);
        }
        catch (WSSPolicyException e) {
            e.printStackTrace();
            throw new AxisFault((Throwable)e);
        }
        catch (RampartException e) {
            e.printStackTrace();
            throw new AxisFault((Throwable)e);
        }
        if (wsResult == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        Vector<WSHandlerResult> results = null;
        results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
        if (results == null) {
            results = new Vector<WSHandlerResult>();
            msgContext.setProperty("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult("", wsResult);
        results.add(0, rResult);
        SOAPHeader header = null;
        try {
            header = msgContext.getEnvelope().getHeader();
        }
        catch (OMException ex) {
            throw new AxisFault("RampartReceiver: cannot get SOAP header after security processing", (Throwable)ex);
        }
        Iterator headers = header.getChildElements();
        SOAPHeaderBlock headerBlock = null;
        while (headers.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)headers.next();
            if (!hb.getLocalName().equals("Security") || !hb.getNamespace().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
            headerBlock = hb;
            break;
        }
        headerBlock.setProcessed();
        return Handler.InvocationResponse.CONTINUE;
    }

    public HandlerDescription getHandlerDesc() {
        return this.handlerDesc;
    }

    public String getName() {
        return "Apache Rampart inflow handler";
    }

    public Parameter getParameter(String name) {
        return this.handlerDesc.getParameter(name);
    }
}

