/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.conversation;

import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.Base64;
import org.apache.axis2.util.Loader;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.conversation.ConversationConfiguration;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.w3c.dom.Element;

public class Util {
    public static Crypto getCryptoInstace(ConversationConfiguration config) throws RampartException {
        if (config.getCrypto() != null) {
            return config.getCrypto();
        }
        Crypto crypto = null;
        if (config.getCryptoClassName() != null && config.getCryptoProperties() != null) {
            crypto = CryptoFactory.getInstance((String)config.getCryptoClassName(), (Properties)config.getCryptoProperties());
        } else if (config.getCryptoPropertiesFile() != null) {
            crypto = config.getClassLoader() != null ? CryptoFactory.getInstance((String)config.getCryptoPropertiesFile(), (ClassLoader)config.getClassLoader()) : CryptoFactory.getInstance((String)config.getCryptoPropertiesFile());
        } else {
            throw new RampartException("cannotCrateCryptoInstance");
        }
        config.setCrypto(crypto);
        return crypto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processRSTR(OMElement rstr, ConversationConfiguration config) throws Exception {
        String ns = null;
        OMElement rstElem = rstr.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedSecurityToken"));
        if (rstElem != null) {
            ns = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        } else {
            rstElem = rstr.getFirstChildWithName(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestedSecurityToken"));
            ns = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        }
        Token token = null;
        if (rstElem == null) throw new TrustException("reqestedSecTokMissing");
        OMElement sctElem = rstElem.getFirstElement();
        if (sctElem == null) {
            throw new RampartException("sctMissingInResponse");
        }
        SecurityContextToken sct = new SecurityContextToken((Element)sctElem);
        token = new Token(sct.getIdentifier(), sctElem, rstr.getFirstChildWithName(new QName(ns, "Lifetime")));
        Util.resgisterContext(sct.getIdentifier(), config);
        byte[] secret = null;
        OMElement rpt = rstr.getFirstChildWithName(new QName(ns, "RequestedProofToken"));
        if (rpt == null) throw new TrustException("rptMissing");
        OMElement elem = rpt.getFirstElement();
        if ("EncryptedKey".equals(elem.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(elem.getNamespace().getNamespaceURI())) {
            EncryptedKeyProcessor processor = new EncryptedKeyProcessor();
            processor.handleToken((Element)elem, null, Util.getCryptoInstace(config), Util.getCallbackHandlerInstance(config), null, new Vector(), null);
            secret = processor.getDecryptedBytes();
        } else {
            if (!"BinarySecret".equals(elem.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/02/trust".equals(elem.getNamespace().getNamespaceURI())) throw new TrustException("notSupported", (Object[])new String[]{"{" + elem.getNamespace().getNamespaceURI() + "}" + elem.getLocalName()});
            secret = Base64.decode((String)elem.getText());
        }
        OMElement reqAttElem = rstr.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedAttachedReference"));
        OMElement reqAttRef = reqAttElem == null ? null : reqAttElem.getFirstElement();
        OMElement reqUnattElem = rstr.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedUnattachedReference"));
        OMElement reqUnattRef = reqUnattElem == null ? null : reqUnattElem.getFirstElement();
        token.setAttachedReference(reqAttRef);
        token.setUnattachedReference(reqUnattRef);
        token.setSecret(secret);
        config.getTokenStore().add(token);
    }

    private static CallbackHandler getCallbackHandlerInstance(ConversationConfiguration config) throws Exception {
        if (config.getPasswordCallbackRef() != null) {
            return config.getPasswordCallbackRef();
        }
        if (config.getPasswordCallbackClass() != null) {
            if (config.getClassLoader() != null) {
                Class clazz = Loader.loadClass((ClassLoader)config.getClassLoader(), (String)config.getPasswordCallbackClass());
                return (CallbackHandler)clazz.newInstance();
            }
            Class clazz = Loader.loadClass((String)config.getPasswordCallbackClass());
            return (CallbackHandler)clazz.newInstance();
        }
        throw new RampartException("noInfoForCBhandler");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resgisterContext(String identifier, ConversationConfiguration config) throws RampartException {
        config.setContextIdentifier(identifier);
        if (config.getScope().equals("operation")) {
            String action = config.getMsgCtx().getSoapAction();
            if (action == null) throw new RampartException("missingWSAAction");
            config.getContextMap().put(action, identifier);
            return;
        } else {
            String to = config.getMsgCtx().getTo().getAddress();
            if (to == null) throw new RampartException("missingWSATo");
            config.getContextMap().put(to, identifier);
        }
    }
}

