/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.conversation;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Base64;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.conversation.ConversationConfiguration;
import org.apache.rampart.conversation.Util;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class STSRequester {
    public static void issueRequest(ConversationConfiguration config) throws RampartException, AxisFault, TrustException {
        MessageContext msgCtx = config.getMsgCtx();
        AxisService axisService = new AxisService("SecurityTokenService");
        QName rstQn = new QName("requestSecurityToken");
        OutInAxisOperation operation = new OutInAxisOperation(rstQn);
        axisService.addOperation((AxisOperation)operation);
        ServiceClient client = new ServiceClient(msgCtx.getConfigurationContext(), axisService);
        Options options = new Options();
        options.setTo(new EndpointReference(config.getStsEPRAddress()));
        options.setAction(TrustUtil.getActionValue((int)config.getWstVersion(), (String)"/RST/SCT"));
        Parameter outFlowParam = msgCtx.getParameter("STSOutflowSecurity");
        Parameter inFlowParam = msgCtx.getParameter("STSInflowSecurity");
        if (outFlowParam == null) {
            outFlowParam = (Parameter)msgCtx.getProperty("STSOutflowSecurity");
        }
        if (inFlowParam == null) {
            inFlowParam = (Parameter)msgCtx.getProperty("STSInflowSecurity");
        }
        options.setProperty("OutflowSecurity", (Object)outFlowParam);
        options.setProperty("InflowSecurity", (Object)inFlowParam);
        client.engageModule(new QName("rampart"));
        client.setOptions(options);
        try {
            OMElement rstElem = TrustUtil.createRequestSecurityTokenElement((int)config.getWstVersion());
            TrustUtil.createRequestTypeElement((int)config.getWstVersion(), (OMElement)rstElem, (String)"/Issue");
            OMElement tokenTypeElem = TrustUtil.createTokenTypeElement((int)config.getWstVersion(), (OMElement)rstElem);
            tokenTypeElem.setText(ConversationConstants.getWSCNs((int)1) + "/sct");
            if (config.isProvideEntropy()) {
                int nonceLength = 16;
                OMElement entropyElem = TrustUtil.createEntropyElement((int)config.getWstVersion(), (OMElement)rstElem);
                byte[] nonce = WSSecurityUtil.generateNonce((int)nonceLength);
                OMElement elem = TrustUtil.createBinarySecretElement((int)config.getWstVersion(), (OMElement)entropyElem, (String)"/Nonce");
                elem.setText(Base64.encode((byte[])nonce));
                TrustUtil.createKeySizeElement((int)config.getWstVersion(), (OMElement)rstElem, (int)(nonceLength * 8));
            }
            OMElement tempResult = client.sendReceive(rstQn, rstElem);
            Axis2Util.useDOOM(true);
            OMElement tempelem = Axis2Util.toDOOM(DOOMAbstractFactory.getOMFactory(), tempResult);
            OMElement elem = (OMElement)config.getDocument().importNode((Element)tempelem, true);
            Util.processRSTR(elem, config);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RampartException("errorInObtainingSct", new String[]{config.getStsEPRAddress()}, e);
        }
    }
}

