/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.conversation;

import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rampart.RampartException;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConversationConfiguration {
    public static final String SC_CONFIG = "sc-configuration";
    public static final String SCOPE_SERVICE = "service";
    public static final String SCOPE_OPERATION = "operation";
    public static final QName SCOPE = new QName("scope");
    public static final QName STS_EPR_ADDRESS = new QName("stsEprAddress");
    public static final QName DERIVED_KEY_LENGTH = new QName("derivedKeyLength");
    public static final QName KEY_DERIVATION_ALGORITHM_CLASS = new QName("keyDerivationAlgorithmClass");
    public static final QName TOKEN_STORE_CLASS = new QName("tokenStoreClass");
    public static final QName CRYPTO_PROPERTIES_FILE = new QName("cryptoProperties");
    public static final QName ENCRYPTION_USER = new QName("encryptionUser");
    public static final QName PW_CALLBACK_CLASS = new QName("passwordCallbackClass");
    private static final QName PROVIDE_ENTROPY = new QName("provideEntropy");
    private String scope = "service";
    private String stsEPRAddress;
    private String derivedKeyLength;
    private String keyDerivationAlgorithmClass;
    private Hashtable contextMap;
    private String tokenStoreClass;
    private TokenStorage tokenStore;
    private MessageContext msgCtx;
    private String contextIdentifier;
    private Properties cryptoProperties;
    private String cryptoClassName;
    private String cryptoPropertiesFile;
    private String passwordCallbackClass;
    private CallbackHandler passwordCallbackRef;
    private boolean sender;
    private Document doc;
    private Crypto crypto;
    private ClassLoader classLoader;
    private SecurityContextToken sct;
    private String encryptionUser;
    private boolean provideEntropy;
    private int wstVersion = 1;

    public static ConversationConfiguration load(MessageContext msgCtx, boolean sender) throws Exception {
        Parameter param = ConversationConfiguration.getParameter(msgCtx);
        if (param != null) {
            OMElement elem = param.getParameterElement();
            if (elem != null && elem.getFirstElement() != null && elem.getFirstElement().getLocalName().equals(SC_CONFIG)) {
                OMElement confElem = elem.getFirstElement();
                ConversationConfiguration config = new ConversationConfiguration();
                config.msgCtx = msgCtx;
                msgCtx.setProperty(SC_CONFIG, (Object)config);
                config.scope = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(SCOPE));
                config.stsEPRAddress = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(STS_EPR_ADDRESS));
                config.keyDerivationAlgorithmClass = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(KEY_DERIVATION_ALGORITHM_CLASS));
                config.tokenStoreClass = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(TOKEN_STORE_CLASS));
                config.cryptoPropertiesFile = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(CRYPTO_PROPERTIES_FILE));
                config.passwordCallbackClass = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(PW_CALLBACK_CLASS));
                config.encryptionUser = ConversationConfiguration.getStringValue(confElem.getFirstChildWithName(ENCRYPTION_USER));
                config.provideEntropy = confElem.getFirstChildWithName(PROVIDE_ENTROPY) != null;
                config.contextMap = (Hashtable)msgCtx.getProperty("contextMap");
                config.doc = Axis2Util.getDocumentFromSOAPEnvelope(msgCtx.getEnvelope(), false);
                config.tokenStore = (TokenStorage)msgCtx.getProperty("org.apache.rahas.TokenStorage");
                if (sender) {
                    if (!msgCtx.isServerSide()) {
                        if (config.scope.equals(SCOPE_OPERATION)) {
                            String action = msgCtx.getSoapAction();
                            config.contextIdentifier = (String)config.getContextMap().get(action);
                        } else {
                            String serviceAddress = msgCtx.getTo().getAddress();
                            config.contextIdentifier = (String)config.getContextMap().get(serviceAddress);
                        }
                        if (config.sct == null && config.contextIdentifier != null) {
                            OMElement tokElem = config.getTokenStore().getToken(config.contextIdentifier).getToken();
                            config.sct = new SecurityContextToken((Element)config.doc.importNode((Element)tokElem, true));
                        }
                    } else {
                        MessageContext inMsgCtx;
                        OperationContext opCtx = msgCtx.getOperationContext();
                        ConversationConfiguration inConfig = null;
                        if (opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
                            inConfig = (ConversationConfiguration)inMsgCtx.getProperty(SC_CONFIG);
                        }
                        if (inConfig == null || inConfig.contextIdentifier == null) {
                            throw new RampartException("canotFindContextIdentifier");
                        }
                        config.contextIdentifier = inConfig.contextIdentifier;
                        config.tokenStore = inConfig.tokenStore;
                        OMElement token = config.tokenStore.getToken(config.contextIdentifier).getToken();
                        config.sct = new SecurityContextToken((Element)config.doc.importNode((Element)token, true));
                        config.setClassLoader(msgCtx.getAxisService().getClassLoader());
                    }
                }
                config.cryptoProperties = (Properties)msgCtx.getProperty("cryptoPropertiesRef");
                config.cryptoClassName = (String)msgCtx.getProperty("cryptoClass");
                config.passwordCallbackRef = (CallbackHandler)msgCtx.getProperty("passwordCallbackRef");
                config.sender = sender;
                return config;
            }
            throw new RampartException("missingConfiguration", new String[]{SC_CONFIG});
        }
        return null;
    }

    public static Parameter getParameter(MessageContext msgCtx) {
        Parameter param = msgCtx.getParameter(SC_CONFIG);
        if (param == null) {
            param = (Parameter)msgCtx.getProperty(SC_CONFIG);
        }
        return param;
    }

    private static String getStringValue(OMElement elem) throws RampartException {
        if (elem != null) {
            return elem.getText();
        }
        return null;
    }

    public Parameter getParameter() {
        Parameter param = new Parameter();
        OMElement element = this.getOMElement();
        OMElement paramElem = element.getOMFactory().createOMElement("parameter", null);
        paramElem.addAttribute("name", SC_CONFIG, null);
        paramElem.addChild((OMNode)element);
        param.setParameterElement(paramElem);
        return param;
    }

    private OMElement getOMElement() {
        OMElement tempElem;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement elem = factory.createOMElement(SC_CONFIG, null);
        if (this.scope != null) {
            tempElem = factory.createOMElement(SCOPE, (OMContainer)elem);
            tempElem.setText(this.scope);
            elem.addChild((OMNode)tempElem);
        }
        if (this.stsEPRAddress != null) {
            tempElem = factory.createOMElement(STS_EPR_ADDRESS, (OMContainer)elem);
            tempElem.setText(this.stsEPRAddress);
            elem.addChild((OMNode)tempElem);
        }
        if (this.derivedKeyLength != null) {
            tempElem = factory.createOMElement(DERIVED_KEY_LENGTH, (OMContainer)elem);
            tempElem.setText(this.derivedKeyLength);
            elem.addChild((OMNode)tempElem);
        }
        if (this.keyDerivationAlgorithmClass != null) {
            tempElem = factory.createOMElement(KEY_DERIVATION_ALGORITHM_CLASS, (OMContainer)elem);
            tempElem.setText(this.keyDerivationAlgorithmClass);
            elem.addChild((OMNode)tempElem);
        }
        if (this.passwordCallbackClass != null) {
            tempElem = factory.createOMElement(PW_CALLBACK_CLASS, (OMContainer)elem);
            tempElem.setText(this.passwordCallbackClass);
            elem.addChild((OMNode)tempElem);
        }
        if (this.cryptoPropertiesFile != null) {
            tempElem = factory.createOMElement(CRYPTO_PROPERTIES_FILE, (OMContainer)elem);
            tempElem.setText(this.cryptoPropertiesFile);
            elem.addChild((OMNode)tempElem);
        }
        if (this.encryptionUser != null) {
            tempElem = factory.createOMElement(ENCRYPTION_USER, (OMContainer)elem);
            tempElem.setText(this.encryptionUser);
            elem.addChild((OMNode)tempElem);
        }
        if (this.provideEntropy) {
            factory.createOMElement(PROVIDE_ENTROPY, (OMContainer)elem);
        }
        return elem;
    }

    public String getScope() {
        return this.scope;
    }

    public String getStsEPRAddress() {
        return this.stsEPRAddress;
    }

    public String getDerivedKeyLength() {
        return this.derivedKeyLength;
    }

    public String getKeyDerivationAlgorithmClass() {
        return this.keyDerivationAlgorithmClass;
    }

    public void setDerivedKeyLength(String derivedKeyLength) {
        this.derivedKeyLength = derivedKeyLength;
    }

    public void setKeyDerivationAlgorithmClass(String keyDerivationAlgorithmClass) {
        this.keyDerivationAlgorithmClass = keyDerivationAlgorithmClass;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setStsEPRAddress(String stsEPRAddress) {
        this.stsEPRAddress = stsEPRAddress;
    }

    protected Hashtable getContextMap() {
        if (this.contextMap == null) {
            this.contextMap = new Hashtable();
            this.msgCtx.getConfigurationContext().setProperty("contextMap", (Object)this.contextMap);
        }
        return this.contextMap;
    }

    public TokenStorage getTokenStore() throws Exception {
        if (this.tokenStore == null) {
            this.tokenStore = (TokenStorage)this.msgCtx.getProperty("org.apache.rahas.TokenStorage" + this.msgCtx.getWSAAction());
            if (this.tokenStore == null) {
                this.tokenStore = (TokenStorage)this.msgCtx.getProperty("org.apache.rahas.TokenStorage" + this.msgCtx.getAxisService().getName());
            }
            if (this.tokenStore == null) {
                this.tokenStore = this.tokenStoreClass != null ? (TokenStorage)Class.forName(this.tokenStoreClass).newInstance() : new SimpleTokenStore();
            }
            if (SCOPE_SERVICE.equals(this.scope)) {
                this.msgCtx.getConfigurationContext().setProperty("org.apache.rahas.TokenStorage", (Object)this.tokenStore);
            } else {
                this.msgCtx.getConfigurationContext().setProperty("org.apache.rahas.TokenStorage", (Object)this.tokenStore);
            }
        }
        return this.tokenStore;
    }

    public String getTokenStoreClass() {
        return this.tokenStoreClass;
    }

    public Properties getCryptoProperties() {
        return this.cryptoProperties;
    }

    public void setCryptoProperties(Properties cryptoProperties) {
        this.cryptoProperties = cryptoProperties;
    }

    public void setTokenStoreClass(String tokenStoreClass) {
        this.tokenStoreClass = tokenStoreClass;
    }

    public String getCryptoPropertiesFile() {
        return this.cryptoPropertiesFile;
    }

    public void setCryptoPropertiesFile(String cryptoPropertiesFile) {
        this.cryptoPropertiesFile = cryptoPropertiesFile;
    }

    public String getCryptoClassName() {
        return this.cryptoClassName;
    }

    public void setCryptoClassName(String cryptoClassName) {
        this.cryptoClassName = cryptoClassName;
    }

    protected boolean isSender() {
        return this.sender;
    }

    public Document getDocument() {
        return this.doc;
    }

    protected void setDocument(Document doc) {
        this.doc = doc;
    }

    public String getPasswordCallbackClass() {
        return this.passwordCallbackClass;
    }

    public CallbackHandler getPasswordCallbackRef() {
        return this.passwordCallbackRef;
    }

    public void setPasswordCallbackClass(String passwordCallbackClass) {
        this.passwordCallbackClass = passwordCallbackClass;
    }

    public String getEncryptionUser() {
        return this.encryptionUser;
    }

    public void setEncryptionUser(String encryptionUser) {
        this.encryptionUser = encryptionUser;
    }

    public boolean isProvideEntropy() {
        return this.provideEntropy;
    }

    public void setProvideEntropy(boolean provideEntropy) {
        this.provideEntropy = provideEntropy;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    protected void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MessageContext getMsgCtx() {
        return this.msgCtx;
    }

    public String getContextIdentifier() {
        return this.contextIdentifier;
    }

    protected void setContextIdentifier(String contextIdentifier) {
        this.contextIdentifier = contextIdentifier;
    }

    public int getWstVersion() {
        return this.wstVersion;
    }

    public void setWstVersion(int wstVersion) {
        this.wstVersion = wstVersion;
    }
}

