/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.conversation;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.rahas.Token;
import org.apache.rampart.conversation.ConversationConfiguration;
import org.apache.rampart.conversation.Util;
import org.apache.ws.security.WSPasswordCallback;

public class ConversationCallbackHandler
implements CallbackHandler {
    private ConversationConfiguration config;

    public ConversationCallbackHandler(ConversationConfiguration config) {
        this.config = config;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifer();
                try {
                    Token tok = this.config.getTokenStore().getToken(id);
                    pc.setKey(tok.getSecret());
                    Util.resgisterContext(id, this.config);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

