/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransportBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog((Class)TransportBindingBuilder.class);

    public void build(RampartMessageData rmd) throws RampartException {
        log.debug((Object)"TransportBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        this.addTimestamp(rmd);
        if (rmd.isClientSide()) {
            SupportingToken endSupptokens;
            SupportingToken sgndEndSuppTokens;
            Vector<byte[]> signatureValues = new Vector<byte[]>();
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            if (sgndSuppTokens != null && sgndSuppTokens.getTokens() != null && sgndSuppTokens.getTokens().size() > 0) {
                log.debug((Object)"Processing signed supporting tokens");
                ArrayList tokens = sgndSuppTokens.getTokens();
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Token token = (Token)iter.next();
                    if (token instanceof UsernameToken) {
                        WSSecUsernameToken utBuilder = this.addUsernameToken(rmd);
                        utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                        utBuilder.prepare(rmd.getDocument());
                        utBuilder.appendToHeader(rmd.getSecHeader());
                        continue;
                    }
                    throw new RampartException("unsupportedSignedSupportingToken", new String[]{"{" + token.getName().getNamespaceURI() + "}" + token.getName().getLocalPart()});
                }
            }
            if ((sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens()) != null && sgndEndSuppTokens.getTokens() != null && sgndEndSuppTokens.getTokens().size() > 0) {
                log.debug((Object)"Processing endorsing signed supporting tokens");
                ArrayList tokens = sgndEndSuppTokens.getTokens();
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Token token = (Token)iter.next();
                    if (token instanceof IssuedToken && rmd.isClientSide()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token));
                        continue;
                    }
                    if (!(token instanceof X509Token)) continue;
                    signatureValues.add(this.doX509TokenSignature(rmd, token));
                }
            }
            if ((endSupptokens = rpd.getEndorsingSupportingTokens()) != null && endSupptokens.getTokens() != null && endSupptokens.getTokens().size() > 0) {
                log.debug((Object)"Processing endorsing supporting tokens");
                ArrayList tokens = endSupptokens.getTokens();
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Token token = (Token)iter.next();
                    if (token instanceof IssuedToken && rmd.isClientSide()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token));
                        continue;
                    }
                    if (!(token instanceof X509Token)) continue;
                    signatureValues.add(this.doX509TokenSignature(rmd, token));
                }
            }
            rmd.getMsgContext().setProperty("_sendSignatureValues_", signatureValues);
        } else {
            this.addSignatureConfirmation(rmd, null);
        }
    }

    private byte[] doX509TokenSignature(RampartMessageData rmd, Token token) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        if (token.isDerivedKeys()) {
            try {
                WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(rmd, token);
                Element bstElem = encrKey.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                encrKey.appendToHeader(rmd.getSecHeader());
                WSSecDKSign dkSig = new WSSecDKSign();
                dkSig.setWsConfig(rmd.getConfig());
                dkSig.setSigCanonicalization(rpd.getAlgorithmSuite().getInclusiveC14n());
                dkSig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
                dkSig.setDerivedKeyLength(rpd.getAlgorithmSuite().getMinimumSymmetricKeyLength() / 8);
                dkSig.setExternalKey(encrKey.getEphemeralKey(), encrKey.getId());
                dkSig.prepare(doc, rmd.getSecHeader());
                Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
                sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
                if (rpd.isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(encrKey.getBSTTokenId()));
                }
                dkSig.setParts(sigParts);
                dkSig.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSig.computeSignature();
                dkSig.appendDKElementToHeader(rmd.getSecHeader());
                dkSig.appendSigToHeader(rmd.getSecHeader());
                return dkSig.getSignatureValue();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = this.getSignatureBuider(rmd, token);
            sig.appendBSTElementToHeader(rmd.getSecHeader());
            Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
            if (rpd.isTokenProtection() && !"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never".equals(token.getInclusion())) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            sig.addReferencesToSign(sigParts, rmd.getSecHeader());
            sig.appendToHeader(rmd.getSecHeader());
            sig.computeSignature();
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
    }

    private byte[] doIssuedTokenSignature(RampartMessageData rmd, Token token) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        String id = RampartUtil.getIssuedToken(rmd, (IssuedToken)token);
        String inclusion = token.getInclusion();
        org.apache.rahas.Token tok = null;
        try {
            tok = rmd.getTokenStorage().getToken(id);
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken", new String[]{id}, e);
        }
        boolean tokenIncluded = false;
        if (inclusion.equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always") || (inclusion.equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient") || inclusion.equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once")) && rmd.isClientSide()) {
            rmd.getSecHeader().getSecurityHeader().appendChild(doc.importNode((Element)tok.getToken(), true));
            tokenIncluded = true;
        }
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign dkSign = new WSSecDKSign();
                OMElement ref = tok.getAttachedReference();
                if (ref == null) {
                    ref = tok.getUnattachedReference();
                }
                if (ref != null) {
                    dkSign.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)ref, true));
                } else {
                    dkSign.setExternalKey(tok.getSecret(), tok.getId());
                }
                dkSign.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
                dkSign.prepare(doc);
                dkSign.appendDKElementToHeader(rmd.getSecHeader());
                Vector<WSEncryptionPart> sigParts = new Vector<WSEncryptionPart>();
                sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
                if (rpd.isTokenProtection() && tokenIncluded) {
                    sigParts.add(new WSEncryptionPart(id));
                }
                dkSign.setParts(sigParts);
                dkSign.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSign.computeSignature();
                dkSign.appendSigToHeader(rmd.getSecHeader());
                return dkSign.getSignatureValue();
            }
            catch (ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        return null;
    }
}

