/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymmetricBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog((Class)SymmetricBindingBuilder.class);

    public void build(RampartMessageData rmd) throws RampartException {
        log.debug((Object)"SymmetricBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (rmd.isClientSide()) {
            this.initializeTokens(rmd);
        }
        if ("EncryptBeforeSigning".equals(rpd.getProtectionOrder())) {
            this.doEncryptBeforeSig(rmd);
        } else {
            this.doSignBeforeEncrypt(rmd);
        }
        log.debug((Object)"SymmetricBindingBuilder build invoked : DONE");
    }

    private void doEncryptBeforeSig(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Vector<Object> signatureValues = new Vector<Object>();
        Token encryptionToken = rpd.getEncryptionToken();
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        if (encryptionToken == null && encrParts.size() > 0) {
            throw new RampartException("encryptionTokenMissing");
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            String tokenId = null;
            org.apache.rahas.Token tok = null;
            if (encryptionToken instanceof IssuedToken) {
                tokenId = rmd.getIssuedEncryptionTokenId();
                log.debug((Object)("Issued EncryptionToken Id : " + tokenId));
            } else if (encryptionToken instanceof SecureConversationToken) {
                tokenId = rmd.getSecConvTokenId();
                log.debug((Object)("SCT Id : " + tokenId));
            } else if (encryptionToken instanceof X509Token) {
                tokenId = this.setupEncryptedKey(rmd, encryptionToken);
            }
            if (tokenId == null || tokenId.length() == 0) {
                throw new RampartException("noSecurityToken");
            }
            tok = this.getToken(rmd, tokenId);
            boolean attached = false;
            Element encrTokenElement = null;
            Element refList = null;
            WSSecDKEncrypt dkEncr = null;
            WSSecEncrypt encr = null;
            Element encrDKTokenElem = null;
            if ("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always".equals(encryptionToken.getInclusion()) || "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once".equals(encryptionToken.getInclusion()) || rmd.isClientSide() && "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient".equals(encryptionToken.getInclusion())) {
                encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, tok.getToken());
                attached = true;
            }
            if (encryptionToken instanceof X509Token) {
                RampartUtil.appendChildToSecHeader(rmd, tok.getToken());
            }
            Document doc = rmd.getDocument();
            if (encryptionToken.isDerivedKeys()) {
                log.debug((Object)"Use drived keys");
                dkEncr = new WSSecDKEncrypt();
                if (attached && tok.getAttachedReference() != null) {
                    dkEncr.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)tok.getAttachedReference(), true));
                } else if (tok.getUnattachedReference() != null) {
                    dkEncr.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)tok.getUnattachedReference(), true));
                } else {
                    dkEncr.setExternalKey(tok.getSecret(), tok.getId());
                }
                try {
                    dkEncr.prepare(doc);
                    encrDKTokenElem = dkEncr.getdktElement();
                    RampartUtil.appendChildToSecHeader(rmd, encrDKTokenElem);
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInDKEncr");
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr");
                }
            }
            log.debug((Object)"NO derived keys, use the shared secret");
            encr = new WSSecEncrypt();
            encr.setWsConfig(rmd.getConfig());
            encr.setEphemeralKey(tok.getSecret());
            encr.setDocument(doc);
            try {
                refList = encr.encryptForExternalRef(null, encrParts);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
            RampartUtil.appendChildToSecHeader(rmd, refList);
            this.setInsertionLocation(encrTokenElement);
            HashMap sigSuppTokMap = null;
            HashMap endSuppTokMap = null;
            HashMap sgndEndSuppTokMap = null;
            Vector sigParts = RampartUtil.getSignedParts(rmd);
            sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
            if (rmd.isClientSide()) {
                SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
                sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
                SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
                endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
                SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
                sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
                sigParts = this.addSignatureParts(sigSuppTokMap, sigParts);
                sigParts = this.addSignatureParts(sgndEndSuppTokMap, sigParts);
            } else {
                this.addSignatureConfirmation(rmd, sigParts);
            }
            signatureValues.add(this.doSymmSignature(rmd, encryptionToken, tok, sigParts));
            this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.getInsertionLocation());
            if (rmd.isClientSide()) {
                Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
                Iterator iter = endSigVals.iterator();
                while (iter.hasNext()) {
                    signatureValues.add(iter.next());
                }
                Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
                Iterator iter2 = sigEndSigVals.iterator();
                while (iter2.hasNext()) {
                    signatureValues.add(iter2.next());
                }
            }
            if (rpd.isSignatureProtection() && this.mainSigId != null) {
                Vector<WSEncryptionPart> secondEncrParts = new Vector<WSEncryptionPart>();
                secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                Element secondRefList = null;
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = dkEncr.encryptForExternalRef(null, secondEncrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorInDKEncr");
                    }
                } else {
                    try {
                        secondRefList = encr.encryptForExternalRef(null, encrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrTokenElement, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorInEncryption", e);
                    }
                }
            }
        } else {
            throw new RampartException("encryptionTokenMissing");
        }
    }

    private void doSignBeforeEncrypt(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        Token sigToken = rpd.getSignatureToken();
        String encrTokId = null;
        String sigTokId = null;
        org.apache.rahas.Token encrTok = null;
        org.apache.rahas.Token sigTok = null;
        Element sigTokElem = null;
        Vector<Object> signatureValues = new Vector<Object>();
        if (sigToken != null) {
            if (sigToken instanceof SecureConversationToken) {
                sigTokId = rmd.getSecConvTokenId();
            } else if (sigToken instanceof IssuedToken) {
                sigTokId = rmd.getIssuedSignatureTokenId();
            } else if (sigToken instanceof X509Token) {
                sigTokId = this.setupEncryptedKey(rmd, sigToken);
            }
        } else {
            throw new RampartException("signatureTokenMissing");
        }
        if (sigTokId == null || sigTokId.length() == 0) {
            throw new RampartException("noSecurityToken");
        }
        sigTok = this.getToken(rmd, sigTokId);
        if ("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always".equals(sigToken.getInclusion()) || "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once".equals(sigToken.getInclusion()) || rmd.isClientSide() && "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient".equals(sigToken.getInclusion())) {
            sigTokElem = RampartUtil.appendChildToSecHeader(rmd, sigTok.getToken());
            this.setInsertionLocation(sigTokElem);
        }
        if (sigToken instanceof X509Token) {
            sigTokElem = RampartUtil.appendChildToSecHeader(rmd, sigTok.getToken());
            this.setInsertionLocation(sigTokElem);
        }
        HashMap sigSuppTokMap = null;
        HashMap endSuppTokMap = null;
        HashMap sgndEndSuppTokMap = null;
        Vector sigParts = RampartUtil.getSignedParts(rmd);
        sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
        if (rmd.isClientSide()) {
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
            SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
            endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
            SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
            sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
            sigParts = this.addSignatureParts(sigSuppTokMap, rpd.getSignedParts());
            sigParts = this.addSignatureParts(sgndEndSuppTokMap, sigParts);
        } else {
            this.addSignatureConfirmation(rmd, sigParts);
        }
        signatureValues.add(this.doSymmSignature(rmd, sigToken, sigTok, sigParts));
        this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.getInsertionLocation());
        if (rmd.isClientSide()) {
            Vector endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
            Iterator iter = endSigVals.iterator();
            while (iter.hasNext()) {
                signatureValues.add(iter.next());
            }
            Vector sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
            Iterator iter2 = sigEndSigVals.iterator();
            while (iter2.hasNext()) {
                signatureValues.add(iter2.next());
            }
        }
        Token encrToken = rpd.getEncryptionToken();
        Element encrTokElem = null;
        if (sigToken.equals(encrToken)) {
            encrTokId = sigTokId;
            encrTok = sigTok;
            encrTokElem = sigTokElem;
        } else {
            encrTokId = rmd.getIssuedEncryptionTokenId();
            encrTok = this.getToken(rmd, encrTokId);
            if ("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always".equals(encrToken.getInclusion()) || "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once".equals(encrToken.getInclusion()) || rmd.isClientSide() && "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient".equals(encrToken.getInclusion())) {
                encrTokElem = (Element)encrTok.getToken();
                RampartUtil.insertSiblingBefore(rmd, sigTokElem, encrTokElem);
            }
        }
        Vector encrParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.mainSigId != null) {
            encrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
        }
        Element refList = null;
        if (encrToken.isDerivedKeys() || encrToken instanceof SecureConversationToken) {
            try {
                WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                if (encrTokElem != null && encrTok.getAttachedReference() != null) {
                    dkEncr.setExternalKey(encrTok.getSecret(), (Element)doc.importNode((Element)encrTok.getAttachedReference(), true));
                } else if (encrTok.getUnattachedReference() != null) {
                    dkEncr.setExternalKey(encrTok.getSecret(), (Element)doc.importNode((Element)encrTok.getUnattachedReference(), true));
                } else {
                    dkEncr.setExternalKey(encrTok.getSecret(), encrTok.getId());
                }
                dkEncr.prepare(doc);
                Element encrDKTokenElem = null;
                encrDKTokenElem = dkEncr.getdktElement();
                if (encrTokElem != null) {
                    RampartUtil.insertSiblingAfter(rmd, encrTokElem, encrDKTokenElem);
                } else {
                    RampartUtil.insertSiblingAfter(rmd, this.timestampElement, encrDKTokenElem);
                }
                refList = dkEncr.encryptForExternalRef(null, encrParts);
                RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, refList);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDKEncr");
            }
            catch (ConversationException e) {
                throw new RampartException("errorInDKEncr");
            }
        }
        try {
            WSSecEncrypt encr = new WSSecEncrypt();
            encr.setWsConfig(rmd.getConfig());
            encr.setEphemeralKey(encrTok.getSecret());
            RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
            encr.setDocument(doc);
            encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            refList = encr.encryptForExternalRef(null, encrParts);
            RampartUtil.insertSiblingAfter(rmd, encrTokElem, refList);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInEncryption", e);
        }
    }

    private String setupEncryptedKey(RampartMessageData rmd, Token sigToken) throws RampartException {
        try {
            WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(rmd, sigToken);
            String id = encrKey.getId();
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(System.currentTimeMillis() + 300000L);
            org.apache.rahas.Token tempTok = new org.apache.rahas.Token(id, (OMElement)encrKey.getEncryptedKeyElement(), created, expires);
            tempTok.setSecret(encrKey.getEphemeralKey());
            rmd.getTokenStorage().add(tempTok);
            String bstTokenId = encrKey.getBSTTokenId();
            if (bstTokenId != null && bstTokenId.length() > 0) {
                RampartUtil.appendChildToSecHeader(rmd, encrKey.getBinarySecurityTokenElement());
            }
            return id;
        }
        catch (TrustException e) {
            throw new RampartException("errorInAddingTokenIntoStore");
        }
    }

    private void initializeTokens(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        MessageContext msgContext = rmd.getMsgContext();
        if (rpd.isSymmetricBinding() && !msgContext.isServerSide()) {
            String id;
            IssuedToken issuedToken;
            log.debug((Object)"Procesing symmentric binding: Setting up encryption token and signature token");
            Token sigTok = rpd.getSignatureToken();
            Token encrTok = rpd.getEncryptionToken();
            if (sigTok instanceof IssuedToken) {
                log.debug((Object)"SignatureToken is an IssuedToken");
                if (rmd.getIssuedSignatureTokenId() == null) {
                    log.debug((Object)"No Issuedtoken found, requesting a new token");
                    issuedToken = (IssuedToken)sigTok;
                    id = RampartUtil.getIssuedToken(rmd, issuedToken);
                    rmd.setIssuedSignatureTokenId(id);
                }
            } else if (sigTok instanceof SecureConversationToken) {
                boolean cancelReqResp;
                log.debug((Object)"SignatureToken is a SecureConversationToken");
                String secConvTokenId = rmd.getSecConvTokenId();
                String action = msgContext.getOptions().getAction();
                boolean bl = cancelReqResp = action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel");
                if (secConvTokenId != null && cancelReqResp) {
                    try {
                        rmd.getTokenStorage().getToken(secConvTokenId).setState(3);
                        msgContext.setProperty("sctID", (Object)secConvTokenId);
                        String contextIdentifierKey = RampartUtil.getContextIdentifierKey(msgContext);
                        RampartUtil.getContextMap(msgContext).remove(contextIdentifierKey);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorExtractingToken");
                    }
                }
                if (secConvTokenId == null || secConvTokenId != null && !RampartUtil.isTokenValid(rmd, secConvTokenId) && !cancelReqResp) {
                    log.debug((Object)"No SecureConversationToken found, requesting a new token");
                    SecureConversationToken secConvTok = (SecureConversationToken)sigTok;
                    try {
                        String id2 = RampartUtil.getSecConvToken(rmd, secConvTok);
                        rmd.setSecConvTokenId(id2);
                    }
                    catch (TrustException e) {
                        throw new RampartException("errorInObtainingSct", e);
                    }
                }
            }
            if (sigTok.equals(encrTok) && sigTok instanceof IssuedToken) {
                log.debug((Object)"Symmetric binding uses a ProtectionToken, both SignatureToken and EncryptionToken are the same");
                rmd.setIssuedEncryptionTokenId(rmd.getIssuedEncryptionTokenId());
            } else {
                log.debug((Object)"Obtaining the Encryption Token");
                if (rmd.getIssuedEncryptionTokenId() != null) {
                    log.debug((Object)"EncrytionToken not alredy set");
                    issuedToken = (IssuedToken)encrTok;
                    id = RampartUtil.getIssuedToken(rmd, issuedToken);
                    rmd.setIssuedEncryptionTokenId(id);
                }
            }
        }
    }
}

