/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.ArrayList;
import org.apache.rampart.RampartMessageData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidatorData {
    private RampartMessageData rmd;
    ArrayList encryptedDataRefIds = new ArrayList();
    private String bodyEncrDataId;

    public ValidatorData(RampartMessageData rmd) {
        this.rmd = rmd;
        this.extractEncryptedPartInformation();
    }

    private void extractEncryptedPartInformation() {
        Node start = this.rmd.getDocument().getDocumentElement();
        while (start != null) {
            Element elem = (Element)WSSecurityUtil.findElement((Node)start, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
            if (elem != null) {
                Element parentElem = (Element)elem.getParentNode();
                if (parentElem != null && parentElem.getLocalName().equals("Body") && parentElem.getNamespaceURI().equals(this.rmd.getSoapConstants().getEnvelopeURI())) {
                    this.bodyEncrDataId = elem.getAttribute("Id");
                } else {
                    this.encryptedDataRefIds.add(elem.getAttribute("Id"));
                }
                if (elem.getNextSibling() != null) {
                    start = elem.getNextSibling();
                    continue;
                }
                start = elem.getParentNode().getNextSibling();
                continue;
            }
            if (start.getNextSibling() != null) {
                start = start.getNextSibling();
                continue;
            }
            start = start.getParentNode().getNextSibling();
        }
    }

    public ArrayList getEncryptedDataRefIds() {
        return this.encryptedDataRefIds;
    }

    public RampartMessageData getRampartMessageData() {
        return this.rmd;
    }

    public String getBodyEncrDataId() {
        return this.bodyEncrDataId;
    }
}

