/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.ws.security.WSPasswordCallback;

public class TokenCallbackHandler
implements CallbackHandler {
    private TokenStorage store;
    private CallbackHandler handler;

    public TokenCallbackHandler(TokenStorage store, CallbackHandler handler) {
        this.store = store;
        this.handler = handler;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (pc.getUsage() == 6 && this.store != null) {
                    String id = pc.getIdentifer();
                    try {
                        Token tok = this.store.getToken(id);
                        if (tok == null) continue;
                        pc.setKey(tok.getSecret());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (this.handler == null) continue;
                this.handler.handle(new Callback[]{pc});
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

