/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.SimpleTokenStore;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RampartMessageData {
    public static final String KEY_RAMPART_POLICY = "rampartPolicy";
    public static final String KEY_ISSUER_ADDRESS = "issuerAddress";
    public static final String KEY_WST_VERSION = "wstVersion";
    public static final String KEY_WSSC_VERSION = "wscVersion";
    public static final String KEY_SCT_ISSUER_POLICY = "sct-issuer-policy";
    public static final String CANCEL_REQUEST = "cancelrequest";
    public static final String SCT_ID = "sctID";
    private MessageContext msgContext = null;
    private RampartPolicyData policyData = null;
    private WSSecHeader secHeader = null;
    private WSSConfig config = null;
    private int timeToLive = 300;
    private String timestampId;
    private Document document;
    private TokenStorage tokenStorage;
    private int wstVersion = 1;
    private int secConvVersion = 1;
    private String issuedEncryptionTokenId;
    private String issuedSignatureTokenId;
    private Policy servicePolicy;
    private boolean isClientSide;
    private boolean sender;
    private ClassLoader customClassLoader;
    private SOAPConstants soapConstants;

    public RampartMessageData(MessageContext msgCtx, boolean sender) throws RampartException {
        this.msgContext = msgCtx;
        try {
            MessageContext outMsgCtx;
            MessageContext inMsgCtx;
            String operationPolicyKey;
            this.document = Axis2Util.getDocumentFromSOAPEnvelope(msgCtx.getEnvelope(), false);
            msgCtx.setEnvelope((SOAPEnvelope)this.document.getDocumentElement());
            this.soapConstants = WSSecurityUtil.getSOAPConstants((Element)this.document.getDocumentElement());
            if (msgCtx.getProperty(KEY_WST_VERSION) != null) {
                this.wstVersion = TrustUtil.getWSTVersion((String)((String)msgCtx.getProperty(KEY_WST_VERSION)));
            }
            if (msgCtx.getProperty(KEY_WSSC_VERSION) != null) {
                this.secConvVersion = TrustUtil.getWSTVersion((String)((String)msgCtx.getProperty(KEY_WSSC_VERSION)));
            }
            if (msgCtx.getProperty(operationPolicyKey = RampartMessageData.getOperationPolicyKey(msgCtx)) != null) {
                this.servicePolicy = (Policy)msgCtx.getProperty(operationPolicyKey);
            }
            String svcPolicyKey = RampartMessageData.getServicePolicyKey(msgCtx);
            if (this.servicePolicy == null && msgCtx.getProperty(svcPolicyKey) != null) {
                this.servicePolicy = (Policy)msgCtx.getProperty(svcPolicyKey);
            }
            if (msgCtx.getProperty(KEY_RAMPART_POLICY) != null) {
                this.servicePolicy = (Policy)msgCtx.getProperty(KEY_RAMPART_POLICY);
            }
            if (this.servicePolicy == null) {
                if (msgCtx.isServerSide()) {
                    this.servicePolicy = msgCtx.getEffectivePolicy();
                } else {
                    Parameter param = msgCtx.getParameter(KEY_RAMPART_POLICY);
                    if (param != null) {
                        OMElement policyElem = param.getParameterElement().getFirstElement();
                        this.servicePolicy = PolicyEngine.getPolicy((OMElement)policyElem);
                    }
                    msgCtx.getConfigurationContext().setProperty(RampartMessageData.getOperationPolicyKey(msgCtx), (Object)this.servicePolicy);
                }
            }
            if (!msgCtx.isServerSide() && this.servicePolicy != null) {
                msgCtx.getServiceContext().setProperty(KEY_RAMPART_POLICY, (Object)this.servicePolicy);
            }
            if (this.servicePolicy != null) {
                List it = (List)this.servicePolicy.getAlternatives().next();
                this.policyData = RampartPolicyBuilder.build(it);
            }
            if (this.isClientSide && this.policyData != null && this.policyData.getRampartConfig() == null) {
                throw new RampartException("rampartConigMissing");
            }
            if (this.policyData != null && ("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT".equals(this.msgContext.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT".equals(this.msgContext.getWSAAction())) && this.policyData.getIssuerPolicy() != null) {
                this.servicePolicy = this.policyData.getIssuerPolicy();
                RampartConfig rampartConfig = this.policyData.getRampartConfig();
                RampartConfig rc = new RampartConfig();
                rc.setEncrCryptoConfig(rampartConfig.getEncrCryptoConfig());
                rc.setSigCryptoConfig(rampartConfig.getSigCryptoConfig());
                rc.setDecCryptoConfig(rampartConfig.getDecCryptoConfig());
                rc.setUser(rampartConfig.getUser());
                rc.setEncryptionUser(rampartConfig.getEncryptionUser());
                rc.setPwCbClass(rampartConfig.getPwCbClass());
                this.servicePolicy.addAssertion((Assertion)rc);
                List it = (List)this.servicePolicy.getAlternatives().next();
                this.policyData = RampartPolicyBuilder.build(it);
            }
            this.isClientSide = !msgCtx.isServerSide();
            this.sender = sender;
            OperationContext opCtx = this.msgContext.getOperationContext();
            if (!this.isClientSide && this.sender && opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null && this.msgContext.getProperty("RECV_RESULTS") == null) {
                this.msgContext.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
                this.msgContext.setProperty(SCT_ID, inMsgCtx.getProperty(SCT_ID));
            }
            if (this.isClientSide && !this.sender && opCtx != null && (outMsgCtx = opCtx.getMessageContext("Out")) != null) {
                this.msgContext.setProperty(SCT_ID, outMsgCtx.getProperty(SCT_ID));
            }
            this.config = WSSConfig.getDefaultWSConfig();
            this.customClassLoader = msgCtx.getAxisService().getClassLoader();
            if (this.policyData != null) {
                this.secHeader = new WSSecHeader();
                this.secHeader.insertSecurityHeader(this.document);
            }
        }
        catch (TrustException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (AxisFault e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSPolicyException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInExtractingMsgProps", e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public WSSConfig getConfig() {
        return this.config;
    }

    public void setConfig(WSSConfig config) {
        this.config = config;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public void setMsgContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public RampartPolicyData getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(RampartPolicyData policyData) throws RampartException {
        this.policyData = policyData;
        try {
            if (this.isClientSide && !this.sender && policyData.isSignatureConfirmation()) {
                OperationContext opCtx = this.msgContext.getOperationContext();
                MessageContext outMsgCtx = opCtx.getMessageContext("Out");
                this.msgContext.setProperty("_sendSignatureValues_", outMsgCtx.getProperty("_sendSignatureValues_"));
            }
        }
        catch (AxisFault e) {
            throw new RampartException("errorGettingSignatureValuesForSigconf", e);
        }
    }

    public WSSecHeader getSecHeader() {
        return this.secHeader;
    }

    public void setSecHeader(WSSecHeader secHeader) {
        this.secHeader = secHeader;
    }

    public String getIssuedEncryptionTokenId() {
        return this.issuedEncryptionTokenId;
    }

    public void setIssuedEncryptionTokenId(String issuedEncryptionTokenId) {
        this.issuedEncryptionTokenId = issuedEncryptionTokenId;
    }

    public String getIssuedSignatureTokenId() {
        return this.issuedSignatureTokenId;
    }

    public void setIssuedSignatureTokenId(String issuedSignatureTokenId) {
        this.issuedSignatureTokenId = issuedSignatureTokenId;
    }

    public String getSecConvTokenId() {
        String id = null;
        if (this.isClientSide) {
            String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
            id = (String)RampartUtil.getContextMap(this.msgContext).get(contextIdentifierKey);
        } else {
            Vector results = (Vector)this.msgContext.getProperty("RECV_RESULTS");
            for (int i = 0; i < results.size(); ++i) {
                WSHandlerResult rResult = (WSHandlerResult)results.get(i);
                Vector wsSecEngineResults = rResult.getResults();
                for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                    WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                    if (1024 != wser.getAction()) continue;
                    id = wser.getSecurityContextToken().getID();
                }
            }
        }
        if (id == null || id.length() == 0) {
            id = (String)this.msgContext.getProperty(SCT_ID);
        }
        return id;
    }

    public void setSecConvTokenId(String secConvTokenId) {
        String contextIdentifierKey = RampartUtil.getContextIdentifierKey(this.msgContext);
        RampartUtil.getContextMap(this.msgContext).put(contextIdentifierKey, secConvTokenId);
    }

    public TokenStorage getTokenStorage() throws RampartException {
        if (this.tokenStorage != null) {
            return this.tokenStorage;
        }
        TokenStorage storage = (TokenStorage)this.msgContext.getProperty("org.apache.rahas.TokenStorage");
        if (storage != null) {
            this.tokenStorage = storage;
        } else {
            String storageClass = this.policyData.getRampartConfig().getTokenStoreClass();
            if (storageClass != null) {
                Class stClass = null;
                try {
                    stClass = Loader.loadClass((ClassLoader)this.msgContext.getAxisService().getClassLoader(), (String)storageClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RampartException("WSHandler: cannot load token storage class: " + storageClass, e);
                }
                try {
                    this.tokenStorage = (TokenStorage)stClass.newInstance();
                }
                catch (Exception e) {
                    throw new RampartException("Cannot create instance of token storage: " + storageClass, e);
                }
            }
            this.tokenStorage = new SimpleTokenStore();
            this.msgContext.getConfigurationContext().setProperty("org.apache.rahas.TokenStorage", (Object)this.tokenStorage);
        }
        return this.tokenStorage;
    }

    public void setTokenStorage(TokenStorage tokenStorage) {
        this.tokenStorage = tokenStorage;
    }

    public int getWstVersion() {
        return this.wstVersion;
    }

    public void setWstVersion(int wstVerion) {
        this.wstVersion = wstVerion;
    }

    public int getSecConvVersion() {
        return this.secConvVersion;
    }

    public Policy getServicePolicy() {
        return this.servicePolicy;
    }

    public void setServicePolicy(Policy servicePolicy) {
        this.servicePolicy = servicePolicy;
    }

    public static String getOperationPolicyKey(MessageContext msgCtx) {
        if (msgCtx.getAxisOperation() != null) {
            return RampartMessageData.createPolicyKey(msgCtx.getAxisService().getName(), msgCtx.getAxisOperation().getName());
        }
        return null;
    }

    public static String getServicePolicyKey(MessageContext msgCtx) {
        return RampartMessageData.createPolicyKey(msgCtx.getAxisService().getName(), null);
    }

    public static String createPolicyKey(String service, QName operation) {
        if (operation != null) {
            return KEY_RAMPART_POLICY + service + "{" + operation.getNamespaceURI() + "}" + operation.getLocalPart();
        }
        return KEY_RAMPART_POLICY + service;
    }

    public String getTimestampId() {
        return this.timestampId;
    }

    public void setTimestampId(String timestampId) {
        this.timestampId = timestampId;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public ClassLoader getCustomClassLoader() {
        return this.customClassLoader;
    }

    public SOAPConstants getSoapConstants() {
        return this.soapConstants;
    }
}

