/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.rampart.PolicyBasedResultsValidator;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Node;

public class RampartEngine {
    public Vector process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        RampartMessageData rmd = new RampartMessageData(msgCtx, false);
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd == null || WSSecurityUtil.findElement((Node)rmd.getDocument().getDocumentElement(), (String)"Fault", (String)rmd.getSoapConstants().getEnvelopeURI()) != null) {
            SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOOMDocument(rmd.getDocument());
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            return null;
        }
        Vector results = null;
        WSSecurityEngine engine = new WSSecurityEngine();
        ValidatorData data = new ValidatorData(rmd);
        results = rpd.isSymmetricBinding() ? engine.processSecurityHeader(rmd.getDocument(), null, (CallbackHandler)new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd)), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader())) : engine.processSecurityHeader(rmd.getDocument(), null, (CallbackHandler)new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd)), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()), RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        SOAPEnvelope env = Axis2Util.getSOAPEnvelopeFromDOOMDocument(rmd.getDocument());
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        PolicyBasedResultsValidator validator = new PolicyBasedResultsValidator();
        validator.validate(data, results);
        return results;
    }
}

