/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;

public class PolicyBasedResultsValidator {
    private static Log log = LogFactory.getLog((Class)PolicyBasedResultsValidator.class);

    public void validate(ValidatorData data, Vector results) throws RampartException {
        Timestamp timestamp;
        X509Certificate returnCert;
        WSSecurityEngineResult actionResult;
        WSSecurityEngineResult tsResult;
        RampartMessageData rmd = data.getRampartMessageData();
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp() && (tsResult = WSSecurityUtil.fetchActionResult((Vector)results, (int)32)) == null) {
            throw new RampartException("timestampMissing");
        }
        Vector encryptedParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.isSignatureRequired(rpd)) {
            encryptedParts.add(new WSEncryptionPart("Signature", "http://www.w3.org/2000/09/xmldsig#", "Element"));
        }
        Vector signatureParts = RampartUtil.getSignedParts(rmd);
        this.validateEncrSig(encryptedParts, signatureParts, results);
        this.validateProtectionOrder(data, results);
        this.validateEncryptedParts(data, results);
        if (!rmd.isClientSide()) {
            this.validateSupportingTokens(data, results);
        }
        if ((actionResult = WSSecurityUtil.fetchActionResult((Vector)results, (int)2)) != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, rmd)) {
            throw new RampartException("trustVerificationError");
        }
        actionResult = WSSecurityUtil.fetchActionResult((Vector)results, (int)32);
        if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, rmd.getTimeToLive())) {
            throw new RampartException("cannotValidateTimestamp");
        }
    }

    private void validateEncrSig(Vector encryptedParts, Vector signatureParts, Vector results) throws RampartException {
        ArrayList actions = this.getSigEncrActions(results);
        boolean sig = false;
        boolean encr = false;
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            Integer act = (Integer)iter.next();
            if (act == 2) {
                sig = true;
                continue;
            }
            if (act != 4) continue;
            encr = true;
        }
        if (sig && signatureParts.size() == 0) {
            throw new RampartException("unexprectedSignature");
        }
        if (!sig && signatureParts.size() > 0) {
            throw new RampartException("signatureMissing");
        }
        if (encr && encryptedParts.size() == 0) {
            ArrayList list = this.getResults(results, 4);
            boolean encrDataFound = false;
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                WSSecurityEngineResult result = (WSSecurityEngineResult)iter2.next();
                if (result.getDataRefUris() == null) continue;
                encrDataFound = true;
            }
            if (encrDataFound) {
                throw new RampartException("unexprectedEncryptedPart");
            }
        } else if (!encr && encryptedParts.size() > 0) {
            throw new RampartException("encryptionMissing");
        }
    }

    private void validateSupportingTokens(ValidatorData data, Vector results) throws RampartException {
        RampartPolicyData rpd = data.getRampartMessageData().getPolicyData();
        SupportingToken suppTok = rpd.getSupportingTokens();
        this.handleSupportingTokens(results, suppTok);
        SupportingToken signedSuppToken = rpd.getSignedSupportingTokens();
        this.handleSupportingTokens(results, signedSuppToken);
        SupportingToken signedEndSuppToken = rpd.getSignedEndorsingSupportingTokens();
        this.handleSupportingTokens(results, signedEndSuppToken);
        SupportingToken endSuppToken = rpd.getEndorsingSupportingTokens();
        this.handleSupportingTokens(results, endSuppToken);
    }

    private void handleSupportingTokens(Vector results, SupportingToken suppTok) throws RampartException {
        if (suppTok == null) {
            return;
        }
        ArrayList tokens = suppTok.getTokens();
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            WSSecurityEngineResult utResult;
            Token token = (Token)iter.next();
            if (!(token instanceof UsernameToken) || (utResult = WSSecurityUtil.fetchActionResult((Vector)results, (int)1)) != null) continue;
            throw new RampartException("usernameTokenMissing");
        }
    }

    private void validateProtectionOrder(ValidatorData data, Vector results) throws RampartException {
        String protectionOrder = data.getRampartMessageData().getPolicyData().getProtectionOrder();
        ArrayList sigEncrActions = this.getSigEncrActions(results);
        if (sigEncrActions.size() < 2) {
            return;
        }
        boolean done = false;
        if ("SignBeforeEncrypting".equals(protectionOrder)) {
            boolean sigfound = false;
            Iterator iter = sigEncrActions.iterator();
            while (iter.hasNext() || !done) {
                Integer act = (Integer)iter.next();
                if (act == 2) {
                    sigfound = true;
                    continue;
                }
                if (!sigfound) continue;
                done = true;
            }
        } else {
            boolean encrFound = false;
            Iterator iter = sigEncrActions.iterator();
            while (iter.hasNext()) {
                Integer act = (Integer)iter.next();
                if (act == 4) {
                    encrFound = true;
                    continue;
                }
                if (!encrFound) continue;
                done = true;
            }
        }
        if (!done) {
            throw new RampartException("protectionOrderMismatch");
        }
    }

    private ArrayList getSigEncrActions(Vector results) {
        ArrayList<Integer> sigEncrActions = new ArrayList<Integer>();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            int action = ((WSSecurityEngineResult)iter.next()).getAction();
            if (2 != action && 4 != action) continue;
            sigEncrActions.add(new Integer(action));
        }
        return sigEncrActions;
    }

    private void validateEncryptedParts(ValidatorData data, Vector results) throws RampartException {
        RampartMessageData rmd = data.getRampartMessageData();
        ArrayList encrRefs = this.getEncryptedReferences(results);
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isEncryptBody() && !encrRefs.contains(data.getBodyEncrDataId())) {
            throw new RampartException("encryptedPartMissing", new String[]{data.getBodyEncrDataId()});
        }
        int refCount = 0;
        if (encrRefs.size() != (refCount += rpd.getEncryptedParts().size())) {
            throw new RampartException("invalidNumberOfEncryptedParts", new String[]{Integer.toString(refCount)});
        }
    }

    private boolean isSignatureRequired(RampartPolicyData rpd) {
        return rpd.isSymmetricBinding() && rpd.getSignatureToken() != null || !rpd.isSymmetricBinding() && !rpd.isTransportBinding() && rpd.getInitiatorToken() != null;
    }

    private boolean verifyTimestamp(Timestamp timestamp, int timeToLive) throws RampartException {
        Calendar validCreation = Calendar.getInstance();
        long currentTime = validCreation.getTime().getTime();
        validCreation.setTime(new Date(currentTime -= (long)(timeToLive * 1000)));
        Calendar cre = timestamp.getCreated();
        return cre == null || cre.after(validCreation);
    }

    protected boolean verifyTrust(X509Certificate cert, RampartMessageData rmd) throws RampartException {
        X509Certificate[] certs;
        if (cert == null) {
            return false;
        }
        String[] aliases = null;
        String alias = null;
        String subjectString = cert.getSubjectDN().getName();
        String issuerString = cert.getIssuerDN().getName();
        BigInteger issuerSerial = cert.getSerialNumber();
        boolean doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("WSHandler: Transmitted certificate has subject " + subjectString));
            log.debug((Object)("WSHandler: Transmitted certificate has issuer " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            alias = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getAliasForX509Cert(issuerString, issuerSerial);
        }
        catch (WSSecurityException ex) {
            throw new RampartException("cannotFindAliasForCert", new String[]{subjectString}, ex);
        }
        if (alias != null) {
            try {
                certs = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new RampartException("noCertForAlias", new String[]{alias}, ex);
            }
            if (certs != null && certs.length > 0 && cert.equals(certs[0])) {
                if (doDebug) {
                    log.debug((Object)("Direct trust for certificate with " + subjectString));
                }
                return true;
            }
        } else if (doDebug) {
            log.debug((Object)("No alias found for subject from issuer with " + issuerString + " (serial " + issuerSerial + ")"));
        }
        try {
            aliases = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getAliasesForDN(issuerString);
        }
        catch (WSSecurityException ex) {
            throw new RampartException("cannotFindAliasForCert", new String[]{issuerString}, ex);
        }
        if (aliases == null || aliases.length < 1) {
            if (doDebug) {
                log.debug((Object)("No aliases found in keystore for issuer " + issuerString + " of certificate for " + subjectString));
            }
            return false;
        }
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
            if (doDebug) {
                log.debug((Object)("Preparing to validate certificate path with alias " + alias + " for issuer " + issuerString));
            }
            try {
                certs = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).getCertificates(alias);
            }
            catch (WSSecurityException ex) {
                throw new RampartException("noCertForAlias", new String[]{alias}, ex);
            }
            if (certs == null | certs.length < 1) {
                throw new RampartException("noCertForAlias", new String[]{alias});
            }
            X509Certificate[] x509certs = new X509Certificate[certs.length + 1];
            x509certs[0] = cert;
            for (int j = 0; j < certs.length; ++j) {
                x509certs[certs.length + j] = cert = certs[i];
            }
            certs = x509certs;
            try {
                if (!RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getCustomClassLoader()).validateCertPath(certs)) continue;
                if (doDebug) {
                    log.debug((Object)("WSHandler: Certificate path has been verified for certificate with subject " + subjectString));
                }
                return true;
            }
            catch (WSSecurityException ex) {
                throw new RampartException("certPathVerificationFailed", new String[]{subjectString}, ex);
            }
        }
        log.debug((Object)("WSHandler: Certificate path could not be verified for certificate with subject " + subjectString));
        return false;
    }

    private ArrayList getEncryptedReferences(Vector results) {
        ArrayList encrResults = this.getResults(results, 4);
        ArrayList<String> refs = new ArrayList<String>();
        Iterator iter = encrResults.iterator();
        while (iter.hasNext()) {
            WSSecurityEngineResult engineResult = (WSSecurityEngineResult)iter.next();
            ArrayList dataRefUris = engineResult.getDataRefUris();
            if (dataRefUris == null) continue;
            Iterator iterator = dataRefUris.iterator();
            while (iterator.hasNext()) {
                String uri = (String)iterator.next();
                refs.add(uri);
            }
        }
        return refs;
    }

    private ArrayList getResults(Vector results, int action) {
        ArrayList<WSSecurityEngineResult> list = new ArrayList<WSSecurityEngineResult>();
        for (int i = 0; i < results.size(); ++i) {
            if (((WSSecurityEngineResult)results.get(i)).getAction() != action) continue;
            list.add((WSSecurityEngineResult)results.get(i));
        }
        return list;
    }
}

