/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustUtil;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.AsymmetricBindingBuilder;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.builder.SymmetricBindingBuilder;
import org.apache.rampart.builder.TransportBindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageBuilder {
    private static Log log = LogFactory.getLog((Class)MessageBuilder.class);

    public void build(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        BindingBuilder builder;
        String isCancelreq;
        MessageContext inMsgCtx;
        OperationContext opCtx;
        Axis2Util.useDOOM(true);
        RampartMessageData rmd = new RampartMessageData(msgCtx, true);
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd == null) {
            return;
        }
        if (!rmd.isClientSide() && (opCtx = msgCtx.getOperationContext()) != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
            msgCtx.setProperty("RECV_RESULTS", inMsgCtx.getProperty("RECV_RESULTS"));
        }
        if ((isCancelreq = (String)msgCtx.getProperty("cancelrequest")) != null && "true".equals(isCancelreq)) {
            try {
                OMElement actionElem;
                SOAPHeader header;
                String cancelAction = TrustUtil.getWSTNamespace((int)rmd.getWstVersion()) + "/RST/SCT/Cancel";
                msgCtx.getOptions().setAction(cancelAction);
                String wsaNs = "http://www.w3.org/2005/08/addressing";
                Object addressingVersionFromCurrentMsgCtxt = msgCtx.getProperty("WSAddressingVersion");
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingVersionFromCurrentMsgCtxt)) {
                    wsaNs = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                }
                if ((header = msgCtx.getEnvelope().getHeader()) != null && (actionElem = header.getFirstChildWithName(new QName(wsaNs, "Action"))) != null) {
                    actionElem.setText(cancelAction);
                }
                String ctxIdKey = RampartUtil.getContextIdentifierKey(msgCtx);
                String tokenId = (String)RampartUtil.getContextMap(msgCtx).get(ctxIdKey);
                if (tokenId == null || !RampartUtil.isTokenValid(rmd, tokenId)) {
                    throw new RampartException("tokenToBeCancelledInvalid");
                }
                SOAPBody bodyElem = msgCtx.getEnvelope().getBody();
                OMElement child = bodyElem.getFirstElement();
                OMElement newChild = TrustUtil.createCancelRequest((String)tokenId, (int)rmd.getWstVersion());
                Element newDomChild = XMLUtils.toDOM((OMElement)newChild);
                Node importedNode = rmd.getDocument().importNode(newDomChild, true);
                ((Element)bodyElem).replaceChild(importedNode, (Element)child);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RampartException("errorInTokenCancellation");
            }
        }
        if (rpd.isTransportBinding()) {
            log.debug((Object)"Building transport binding");
            TransportBindingBuilder building = new TransportBindingBuilder();
            building.build(rmd);
        } else if (rpd.isSymmetricBinding()) {
            log.debug((Object)"Building SymmetricBinding");
            builder = new SymmetricBindingBuilder();
            ((SymmetricBindingBuilder)builder).build(rmd);
        } else {
            builder = new AsymmetricBindingBuilder();
            ((AsymmetricBindingBuilder)builder).build(rmd);
        }
    }
}

